/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.newGift.dao.GiftDao;
import com.xunlei.niux.data.newGift.vo.Gift;
import com.xunlei.niux.data.newGift.vo.GiftAct;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

public class GiftDaoImpl
extends BaseDaoImpl
implements GiftDao {
    @Override
    public List<Gift> getGiftsByLogin(Gift gift, Page page, String login) {
        GiftAct act = new GiftAct();
        act.setActStaff(login);
        act.setStatus(1);
        Page page1 = new Page();
        page1.addOrder("isAdmin", OrderType.DESC);
        List byObject = this.findByObject(GiftAct.class, act, page1);
        if (byObject == null || byObject.size() == 0) {
            return null;
        }
        if (((GiftAct)byObject.get(0)).getIsAdmin() == 1) {
            return this.findByObject(Gift.class, gift, page);
        }
        String actNos = "";
        for (GiftAct act1 : byObject) {
            actNos = actNos + "'" + act1.getActNo() + "',";
        }
        actNos = actNos.substring(0, actNos.length() - 1);
        ArrayList<Object> list = new ArrayList<Object>();
        String sql = "select * from gift where 1=1 ";
        sql = sql + this.getConditon(gift, list, actNos);
        sql = sql + " order by editTime desc ";
        if (page.getPageNo() <= 0) {
            page.setPageNo(1);
        }
        sql = sql + " limit " + (page.getPageNo() - 1) * page.getPageSize() + ", " + page.getPageSize();
        List gifts = this.findBySql(Gift.class, sql, list);
        return gifts;
    }

    private String getConditon(Gift gift, List<Object> list, String actNos) {
        String sql = "";
        if (gift.getSeqId() != null && gift.getSeqId() > 0L) {
            sql = sql + " and seqId = ? ";
            list.add(gift.getSeqId());
        }
        if (StringUtils.isNotEmpty((String)gift.getActNo())) {
            sql = sql + " and actNo = ? ";
            list.add(gift.getActNo());
        }
        if (StringUtils.isNotEmpty((String)gift.getGiftName())) {
            sql = sql + " and giftName = ? ";
            list.add(gift.getGiftName());
        }
        if (gift.getModelNo() != null && gift.getModelNo() > 0L) {
            sql = sql + " and modelNo = ? ";
            list.add(gift.getModelNo());
        }
        if (StringUtils.isNotEmpty((String)gift.getAdvNo())) {
            sql = sql + " and advNo = ? ";
            list.add(gift.getAdvNo());
        }
        if (actNos.length() > 1) {
            sql = sql + " and actNo in (" + actNos + ") ";
        }
        return sql;
    }

    @Override
    public int countGiftsByLogin(Gift gift, String login) {
        GiftAct act = new GiftAct();
        act.setActStaff(login);
        act.setStatus(1);
        Page page1 = new Page();
        page1.addOrder("isAdmin", OrderType.DESC);
        List byObject = this.findByObject(GiftAct.class, act, page1);
        if (byObject == null || byObject.size() == 0) {
            return 0;
        }
        if (((GiftAct)byObject.get(0)).getIsAdmin() == 1) {
            return this.count(gift);
        }
        String actNos = "";
        for (GiftAct act1 : byObject) {
            actNos = actNos + "'" + act1.getActNo() + "',";
        }
        actNos = actNos.substring(0, actNos.length() - 1);
        ArrayList<Object> list = new ArrayList<Object>();
        String sql = "select count(*) from gift where 1=1 " + this.getConditon(gift, list, actNos);
        return this.getJdbcTemplate().queryForInt(sql, list.toArray());
    }

    @Override
    public Map<String, Object> getGiftMap(String actNo, int modelNo) {
        String sql = "select * from gift\nLEFT JOIN giftextinfo on gift.seqid = giftextinfo.giftId\nwhere actNo=? and modelNo=? and gift.status = ?\nORDER BY gift.seqId DESC ,giftextinfo.type ,giftextinfo.seqId DESC";
        final HashMap<String, Object> map = new HashMap<String, Object>();
        this.getJdbcTemplate().query(sql, new Object[]{actNo, modelNo, 1}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                if (!map.containsKey("giftId")) {
                    map.put("giftId", rs.getString("seqId"));
                    map.put("giftName", rs.getString("giftname"));
                    map.put("modelNo", rs.getString("modelNo"));
                    map.put("advNo", rs.getString("advNo"));
                    map.put("startTime", rs.getString("startTime"));
                    map.put("endTime", rs.getString("endTime"));
                    map.put("total", rs.getString("total"));
                    map.put("leftNm", rs.getString("leftNm"));
                    map.put("orderNo", rs.getString("orderNo"));
                    map.put("extInfo", new ArrayList());
                }
                HashMap<String, String> extInfoMap = new HashMap<String, String>();
                extInfoMap.put("type", rs.getString("type"));
                extInfoMap.put("keyCode", rs.getString("keyCode"));
                extInfoMap.put("keyValue", rs.getString("keyValue"));
                ((List)map.get("extInfo")).add(extInfoMap);
            }
        });
        return map;
    }

    @Override
    public Gift getGiftByLock(long id) {
        String sql = "select * from gift where seqId = ?  for update";
        ArrayList<Long> param = new ArrayList<Long>();
        param.add(id);
        List bySql = this.findBySql(Gift.class, sql, param);
        return bySql == null || bySql.size() == 0 ? null : (Gift)bySql.get(0);
    }

    @Override
    public List<Map<String, Object>> getExtGifts(String actNo, int size) {
        String sql = "SELECT gtmp.seqId, gtmp.giftName,gtmp.modelNo,gtmp.orderNo,gei.type,gei.keyCode,gei.keyValue,gei.status,gtmp.startTime,gtmp.endTime,gtmp.total,gtmp.leftNm,gtmp.advNo,gtmp.actNo,gtmp.bonusType,gtmp.bonus,gtmp.monthTotal,gtmp.weekTotal,gtmp.dayTotal from \n(SELECT gift.seqId, gift.giftName,gift.modelNo,gift.orderNo,gift.advNo,gift.actNo,gift.bonusType,gift.bonus, gift.startTime,gift.endTime,gift.total,gift.leftNm,gift.monthTotal,gift.weekTotal,gift.dayTotal FROM gift  INNER JOIN \n                (SELECT  max(orderNo) as orderNo,modelNo,actNo  from gift  where actNo= ? and status =1 \n                 and startTime < NOW() and endTime > NOW() group by modelNo order by modelNo ) g  \n                on gift.actNo = g.actNo and gift.modelNo = g.modelNo and gift.orderNo = g.OrderNo limit ? ) gtmp \nleft join giftextinfo gei on gtmp.seqid = gei.giftid AND gei.status =1  order by gtmp.modelNo ,gtmp.orderNo,gei.seqid   ";
        final ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.getJdbcTemplate().query(sql, new Object[]{actNo, size}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long seqid = rs.getLong("seqId");
                Map<String, Object> map = list.size() == 0 ? null : (Map)list.get(list.size() - 1);
                Long mapSeqId = map == null || map.get("seqId") == null ? 0L : (Long)map.get("seqId");
                if (mapSeqId != seqid) {
                    map = new HashMap<String, Object>();
                    list.add(map);
                    map.put("seqId", rs.getLong("seqId"));
                    map.put("giftName", rs.getString("giftName"));
                    map.put("giftId", rs.getString("seqId"));
                    map.put("actNo", rs.getString("actNo"));
                    map.put("modelNo", rs.getString("modelNo"));
                    map.put("advNo", rs.getString("advNo"));
                    map.put("startTime", rs.getString("startTime"));
                    map.put("endTime", rs.getString("endTime"));
                    map.put("total", rs.getString("total"));
                    map.put("leftNm", rs.getString("leftNm"));
                    map.put("orderNo", rs.getString("orderNo"));
                    map.put("bonusType", rs.getString("bonusType"));
                    map.put("bonus", rs.getString("bonus"));
                    map.put("extInfo", new ArrayList());
                }
                if (StringUtils.isNotEmpty((String)rs.getString("type"))) {
                    HashMap<String, String> extInfoMap = new HashMap<String, String>();
                    extInfoMap.put("type", rs.getString("type"));
                    extInfoMap.put("keyCode", rs.getString("keyCode"));
                    extInfoMap.put("keyValue", rs.getString("keyValue"));
                    ((List)map.get("extInfo")).add(extInfoMap);
                }
            }
        });
        return list;
    }

    @Override
    public List<Gift> getGiftsByActNo(String actNo, int size) {
        String sql = "select * from gift where actNo=? and `status`=1 and startTime<=NOW() and endTime >= NOW() order by orderNo desc limit ? \n";
        ArrayList<Object> param = new ArrayList<Object>(2);
        param.add(actNo);
        param.add(size);
        List gifts = this.findBySql(Gift.class, sql, param);
        return gifts;
    }

    @Override
    public List<Map<String, Object>> getMobileWeekGifts(String actNo, int size) {
        String sql = "SELECT gift.seqId, gift.giftName,gift.modelNo,gift.orderNo FROM gift  INNER JOIN \n(SELECT  max(orderNo) as orderNo,modelNo,actNo  from gift  where actNo= ? and status =1 and startTime < NOW() and endTime > NOW() group by modelNo order by modelNo ) g \non gift.actNo = g.actNo and gift.modelNo = g.modelNo and gift.orderNo = g.OrderNo order by modelNo  LIMIT ? \n";
        final ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.getJdbcTemplate().query(sql, new Object[]{actNo, size}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("giftId", rs.getLong("seqId"));
                map.put("giftName", rs.getString("giftname"));
                map.put("orderNo", rs.getInt("orderNo"));
                map.put("modelNo", rs.getInt("modelNo"));
                list.add(map);
            }
        });
        return list;
    }

    @Override
    public List<Map<String, Object>> getExtMapGifts(String actNo, int size) {
        String sql = "SELECT gtmp.seqId, gtmp.giftName,gtmp.modelNo,gtmp.orderNo,gei.type,gei.keyCode,gei.keyValue,gei.status,gtmp.startTime,gtmp.endTime,gtmp.total,gtmp.leftNm,gtmp.advNo,gtmp.actNo,gtmp.bonusType,gtmp.bonus,gtmp.monthTotal,gtmp.weekTotal,gtmp.dayTotal from \n(SELECT gift.seqId, gift.giftName,gift.modelNo,gift.orderNo,gift.advNo,gift.actNo,gift.bonusType,gift.bonus, gift.startTime,gift.endTime,gift.total,gift.leftNm,gift.monthTotal,gift.weekTotal,gift.dayTotal FROM gift  INNER JOIN \n                (SELECT  max(orderNo) as orderNo,modelNo,actNo  from gift  where actNo= ? and status =1 \n                 and startTime < NOW() and endTime > NOW() group by modelNo order by modelNo ) g  \n                on gift.actNo = g.actNo and gift.modelNo = g.modelNo and gift.orderNo = g.OrderNo limit ? ) gtmp \nleft join giftextinfo gei on gtmp.seqid = gei.giftid AND gei.status =1  order by gtmp.modelNo ,gtmp.orderNo,gei.seqid   ";
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Object[] params = new Object[]{actNo, size};
        this.getList4Map(list, sql, params);
        return list;
    }

    @Override
    public Map<String, Object> getGiftInfoMap(Long giftId) {
        String sql = "select * from gift\nLEFT JOIN giftextinfo on gift.seqid = giftextinfo.giftId\nwhere gift.seqId= ?  and gift.status = ?\nORDER BY gift.seqId DESC ,giftextinfo.type ,giftextinfo.seqId DESC";
        final HashMap<String, Object> map = new HashMap<String, Object>();
        this.getJdbcTemplate().query(sql, new Object[]{giftId, 1}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                GiftDaoImpl.this.addInfo2Map(map, rs);
            }
        });
        return map;
    }

    private List<Map<String, Object>> getList4Map(final List<Map<String, Object>> list, String sql, Object[] params) {
        this.getJdbcTemplate().query(sql, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long seqid = rs.getLong("seqId");
                Map map = list.size() == 0 ? null : (Map)list.get(list.size() - 1);
                Long mapSeqId = map == null || map.get("seqId") == null ? 0L : (Long)map.get("seqId");
                if (mapSeqId.longValue() != seqid.longValue()) {
                    map = new HashMap();
                    list.add(map);
                }
                GiftDaoImpl.this.addInfo2Map(map, rs);
            }
        });
        return list;
    }

    private void addInfo2Map(Map<String, Object> map, ResultSet rs) throws SQLException {
        if (!map.containsKey("giftId")) {
            map.put("giftId", rs.getString("seqId"));
            map.put("modelNo", rs.getString("modelNo"));
            map.put("giftName", rs.getString("giftname"));
            map.put("advNo", rs.getString("advNo"));
            map.put("startTime", rs.getString("startTime"));
            map.put("endTime", rs.getString("endTime"));
            map.put("total", rs.getString("total"));
            map.put("leftNm", rs.getString("leftNm"));
            map.put("orderNo", rs.getString("orderNo"));
            map.put("seqId", rs.getLong("seqId"));
            map.put("bonus", rs.getString("bonus"));
            map.put("actNo", rs.getString("actNo"));
            map.put("bonusType", rs.getString("bonusType"));
            map.put("monthTotal", rs.getInt("monthTotal"));
            map.put("weekTotal", rs.getInt("weekTotal"));
            map.put("dayTotal", rs.getInt("dayTotal"));
        }
        if (StringUtils.isNotEmpty((String)rs.getString("type"))) {
            map.put(rs.getString("type").trim() + "_" + rs.getString("keyCode").trim(), rs.getString("keyValue").trim());
        }
    }

    @Override
    public List<Map<String, Object>> getGiftInfoByBath(Long ... giftId) {
        if (giftId.length == 0) {
            return Collections.EMPTY_LIST;
        }
        String sql = "select * from gift\n LEFT JOIN giftextinfo on gift.seqid = giftextinfo.giftId\n where gift.seqId in ( " + StringUtils.join((Object[])giftId, (String)",") + " ) and gift.status = ?  \n " + " ORDER BY gift.seqId DESC ,giftextinfo.type ,giftextinfo.seqId DESC";
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Object[] params = new Object[]{1};
        this.getList4Map(list, sql, params);
        return list;
    }

    @Override
    public List<Map<String, Object>> getGiftsByAdvNo(String advNo, int size) {
        if (StringUtils.isEmpty((String)advNo)) {
            return Collections.EMPTY_LIST;
        }
        String sql = "SELECT gtmp.seqId, gtmp.giftName,gtmp.modelNo,gtmp.orderNo,gei.type,gei.keyCode,gei.keyValue,gei.status,gtmp.startTime,gtmp.endTime,gtmp.total,gtmp.leftNm,gtmp.advNo,gtmp.actNo,gtmp.bonusType,gtmp.bonus,gtmp.monthTotal,gtmp.weekTotal,gtmp.dayTotal from \n(SELECT gift.seqId, gift.giftName,gift.modelNo,gift.orderNo,gift.advNo,gift.actNo,gift.bonusType,gift.bonus, gift.startTime,gift.endTime,gift.total,gift.leftNm,gift.monthTotal,gift.weekTotal,gift.dayTotal FROM gift  INNER JOIN \n                (SELECT  max(orderNo) as orderNo,modelNo,actNo  from gift  where advNo = ? and status =1 \n                 and startTime < NOW() and endTime > NOW() group by modelNo order by modelNo ) g  \n                on gift.actNo = g.actNo  and gift.modelNo = g.modelNo and gift.orderNo = g.OrderNo limit ? ) gtmp \nleft join giftextinfo gei on gtmp.seqid = gei.giftid AND gei.status =1  order by gtmp.modelNo ,gtmp.orderNo,gei.seqid   ";
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Object[] params = new Object[]{advNo, size};
        this.getList4Map(list, sql, params);
        return list;
    }
}

