package com.xunlei.niux.data.newGift.util;

/**
 * Created by zhangya on 2017/1/11.
 */
public abstract class DBCas<T> {

    private static Integer DefaultRetryTime = 50;

    private int retryTime ;

    public DBCas(int retryTime) {
        this.retryTime = retryTime;
    }

    public DBCas() {
        retryTime = DefaultRetryTime;
    }

    /**
     *
     * @return      获取要查询的数据
     */
    public abstract  T getObject();

    /**
     *
     * @param t
     * @return          根据业务对对象t进行业务操作，从而改变t的值
     */
    protected  T operatorObject(T t){
        return t;
    }

    /**
     *
     * @param t
     * @return      对数据库进行更新操作
     */
    public abstract int updateDB(T t);

    /**
     * 执行数据库层次的CAS操作
     * 1、获取对象
     */
    public Boolean cas(){
        boolean flag = Boolean.FALSE;
        for(int i = 0 ; i < retryTime ; i++){
           T t = getObject();
           t = operatorObject(t);
           if(t == null ){
               flag = Boolean.TRUE;
               break;
           }
            int count = updateDB(t);
            if(count>0){
                flag = Boolean.TRUE;
                break;
            }
        }
        return flag;
    }
}
