package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.newGift.util.DBCas;
import com.xunlei.niux.data.newGift.vo.GiftAct;
import com.xunlei.niux.data.newGift.vo.GiftExchargeRecord;
import com.xunlei.niux.data.newGift.vo.GiftRecordTotal;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * Created by zy on 2016/4/11.
 */
public class GiftExchargeRecordDaoImpl extends BaseDaoImpl implements GiftExchargeRecordDao {

    @Override
    public int getCountByIP(String ip, long giftId) {
        String sql ="select count(*) from giftexchargerecord where ip =? and giftId =?  and status =1 ";
        return this.getJdbcTemplate().queryForInt(sql,new Object[]{ip,giftId});
    }

    @Override
    public int getCountByUserId(String userId, long giftId) {
        String sql ="select count(*) from giftexchargerecord where userId =? and giftId =? AND status =1 ";
        return this.getJdbcTemplate().queryForInt(sql,new Object[]{userId,giftId});
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo, String startTime, String endTime, int pageSize, int pageNo) {
        return getActRecords(userId,actNo,0L,startTime,endTime,pageSize,pageNo);
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo,Long giftId,String startTime,String endTime,int pageSize,int pageNo) {
        String sql = " select SUBSTRING(recordTime,1,19) as recordTime,giftexchargerecord.* from  giftexchargerecord where userId = ? and status = 1  ";
        List<Object> param = new ArrayList<Object>();
        param.add(userId);
        if(StringUtils.isNotEmpty(actNo)){
            param.add(actNo);
            sql += " and actNo = ? ";
        }
        if(giftId>0L){
            param.add(giftId);
            sql += " and giftId  = ? ";
        }

        if(StringUtils.isNotEmpty(startTime)){
            param.add(startTime);
            sql += " and recordTime >= ?";
        }

        if(StringUtils.isNotEmpty(endTime)){
            param.add(endTime);
            sql += " and recordTime <= ?";
        }

        sql += " order by recordTime desc ";

        if(pageNo > 0&&pageSize>0){
            sql +=" limit "+(pageNo-1)*pageSize+","+pageSize;
        }else if(pageSize > 0 ){
            sql += " limit "+ pageSize;
        }

        return findBySql(GiftExchargeRecord.class,sql,param);
    }

    @Override
    public List<GiftExchargeRecord> getGiftRecordsByLogin(GiftExchargeRecord record, Page page, String login) {
        GiftAct act = new GiftAct();
        act.setActStaff(login);
        act.setStatus(1);
        Page page1 = new Page();
        page1.addOrder("isAdmin", OrderType.DESC);
        List<GiftAct> byObject = findByObject(GiftAct.class, act,page1 );
        if(byObject==null||byObject.size()==0){
            return null;
        }

        if(byObject.get(0).getIsAdmin()==1){
            return findByObject(GiftExchargeRecord.class,record,page);
        }

        String actNos = "";
        for(GiftAct act1 : byObject){
            actNos += "'"+act1.getActNo()+"',";
        }

        actNos = actNos.substring(0,actNos.length()-1);
        List<Object> list = new ArrayList<Object>();

        String sql = "select * from giftexchargerecord ger where 1=1 ";

        sql += getConditon(record,list,actNos);

        sql += " order by ger.recordTime desc ";

        if(page.getPageNo()<=0){
            page.setPageNo(1);
        }

        sql += " limit "+((page.getPageNo()-1)*page.getPageSize()) +", "+page.getPageSize();

        List<GiftExchargeRecord> giftExchargeRecords = findBySql(GiftExchargeRecord.class, sql, list);

        return giftExchargeRecords;
    }

    @Override
    public int countGiftRecordsByLogin(GiftExchargeRecord record, String login) {
        GiftAct act = new GiftAct();
        act.setStatus(1);
        act.setActStaff(login);
        Page page1 = new Page();
        page1.addOrder("isAdmin", OrderType.DESC);
        List<GiftAct> byObject = findByObject(GiftAct.class, act,page1 );
        if(byObject==null||byObject.size()==0){
            return 0;
        }

        if(byObject.get(0).getIsAdmin()==1){
            return count(record);
        }

        String actNos = "";
        for(GiftAct act1 : byObject){
            actNos += "'"+act1.getActNo()+"',";
        }
        actNos = actNos.substring(0,actNos.length()-1);
        List<Object> list =  new ArrayList<Object>();
        String sql = "select count(*) from giftexchargerecord ger where 1=1 " + getConditon(record,list,actNos);
        return getJdbcTemplate().queryForInt(sql, list.toArray());
    }

    private String getConditon(GiftExchargeRecord record,List<Object> list,String actNos){
        String sql = "";
        if(record.getSeqId()!=null&&record.getSeqId()>0){
            sql += " and ger.seqId = ? ";
            list.add(record.getSeqId());
        }

        if(record.getUserId()!=null&&record.getUserId()>0){
            sql += " and ger.userId = ? ";
            list.add(record.getUserId());
        }

        if(StringUtils.isNotEmpty(record.getActNo())){
            sql += " and ger.actNo = ? ";
            list.add(record.getActNo());
        }

        if(record.getGiftId()!=null && record.getGiftId().intValue()>0){
            sql += " and ger.giftId = ? ";
            list.add(record.getGiftId());
        }

        if(StringUtils.isNotEmpty(record.getActNm())){
            sql += " and ger.actNm = ? ";
            list.add(record.getActNm());
        }

        if(StringUtils.isNotEmpty(record.getGiftNm())){
            sql += " and ger.giftNm = ? ";
            list.add(record.getGiftNm());
        }

        if(StringUtils.isNotEmpty(record.getFromRecordTime())){
            sql +=" and ger.recordTime >= ? ";
            list.add(record.getFromRecordTime());
        }

        if(StringUtils.isNotEmpty(record.getEndRecordTime())){
            sql += " and ger.recordTime <= ? ";
            list.add(record.getEndRecordTime());
        }

        if(record.getStatus()!=null&&record.getStatus()>-1){
            sql += " and ger.status = ? ";
            list.add(record.getStatus());
        }

        if(actNos.length()>1){
            sql += " and actNo in ("+ actNos+") ";
        }
        return sql;

    }

    @Override
    public List<GiftExchargeRecord> getRecords4Move(String actNo) {
        String sql = "select ger.* from giftexchargerecord ger " +
                " left join resources r on ger.resourceId = r.seqId  " +
                " where r.resourceType='product' and ger.actNo='"+actNo+"' and  ger.status in (1,2)" +
                " order by recordTime desc ";
        List<GiftExchargeRecord> bySql = findBySql(GiftExchargeRecord.class, sql, new ArrayList<Object>());
        return bySql;
    }

    @Override
    public int getActRecordsCount(String userId, String actNo, Long giftId, String startTime, String endTime) {
        String sql = " select COUNT(*)  from  giftexchargerecord where userId = ? and status = 1  ";
        List<Object> param = new ArrayList<Object>();
        param.add(userId);
        if(StringUtils.isNotEmpty(actNo)){
            param.add(actNo);
            sql += " and actNo = ? ";
        }
        if(giftId>0L){
            param.add(giftId);
            sql += " and giftId  = ? ";
        }

        if(StringUtils.isNotEmpty(startTime)){
            param.add(startTime);
            sql += " and recordTime >= ?";
        }

        if(StringUtils.isNotEmpty(endTime)){
            param.add(endTime);
            sql += " and recordTime <= ?";
        }

        return getJdbcTemplate().queryForInt(sql, param.toArray());

    }

    @Override
    public List<GiftExchargeRecord> getGiftRecords4ActNos (GiftExchargeRecord record,  String type,String actNos , Page page,String outResourceType) {
        StringBuilder  sql =  new StringBuilder("select * from giftexchargerecord ger where 1=1   ");
        List<Object> param = new ArrayList<Object>();
        sql.append(getCondition4Type(record,param,actNos,type,outResourceType));
        sql.append("  order by ger.recordTime desc ");

        if(page!= null){
            if(page.getPageNo()<=0){
                page.setPageNo(1);
            }
            sql.append( " limit "+((page.getPageNo()-1)*page.getPageSize()) +", "+page.getPageSize());
        }

        return findBySql(GiftExchargeRecord.class,sql.toString(),param);
    }

    @Override
    public int getGiftRecordsCount4ActNos(GiftExchargeRecord record,  String type, String actNos,String outResourceType) {
        StringBuilder  sql =  new StringBuilder("select count(*) from giftexchargerecord ger  where 1 =1 ");
        List<Object> param = new ArrayList<Object>();
        sql.append(getCondition4Type(record,param,actNos,type,outResourceType));
        return this.getJdbcTemplate().queryForInt(sql.toString(),param.toArray());
    }

    private String getCondition4Type(GiftExchargeRecord record,List param,String actNos ,String type,String outResourceType){
        String result = getConditon(record,param,actNos);
        if(StringUtils.isNotEmpty(type)){
            if(type.equals("product")){
                result += " and  serialType = ? ";
                param.add(type);
            }else if(type.equals("vm")) {
                result += " and  serialType != ? ";
                param.add("product");
            }else if(type.equals("takeoff")) {
                result += " and  bonusType!=null and bonus > 0 ";
            }

        }

        if(StringUtils.isNotEmpty(outResourceType)){
            result += " and serialType not in ("+outResourceType+") ";
        }
        return result;
    }

    @Override
    public void updateGiftRecordTotal(String type, String keyCode, Long giftId) {

    }

    private String getStatisticsSql(String startTime,String endTime , Long ... giftId){
        String sql = "select ";
        return  sql;
    }

    @Override
    public void addStatisticsLeftNm(final String type,final String keyCode,final Long giftId) {
        new DBCas<GiftRecordTotal>() {
            @Override
            public GiftRecordTotal getObject() {
                GiftRecordTotal total = new GiftRecordTotal();
                total.setGiftId(giftId);
                total.setType(type);
                total.setKeyCode(keyCode);
                Page page = new Page();
                List<GiftRecordTotal> list = findByObject(GiftRecordTotal.class, total, page);
                return (list == null || list.size() == 0) ? null : list.get(0);
            }

            @Override
            protected GiftRecordTotal operatorObject(GiftRecordTotal giftRecordTotal) {
                if(giftRecordTotal == null){
                    GiftRecordTotal total = new GiftRecordTotal();
                    total.setType(type);
                    total.setKeyCode(keyCode);
                    total.setGiftId(giftId);
                    total.setKeyValue(1);
                    total.setStatus(1);
                    insert(total);
                    return null;
                }else if(giftRecordTotal.getStatus()==2){
                    giftRecordTotal.setStatus(1);
                    giftRecordTotal.setKeyValue(1);
                    updateById(giftRecordTotal);
                    return null;
                }
                return giftRecordTotal;
            }

            @Override
            public int updateDB(GiftRecordTotal giftRecordTotal) {
                String sql = "update giftrecordtotal set keyValue= ? where seqid = ? and keyValue = ? ";
                List<Object> param = new ArrayList<Object>(3);
                param.add(giftRecordTotal.getKeyValue() + 1);
                param.add(giftRecordTotal.getSeqId());
                param.add(giftRecordTotal.getKeyValue());
                return getJdbcTemplate().update(sql, param.toArray());
            }
        }.cas();
    }

    @Override
    public Map<String, Object> getGiftStatisticsData(Long... giftId) {
        if(giftId.length==0){
            return null;
        }

        String sql = "select gt.*,gift.total,gift.leftNm,gift.dayTotal,gift.weekTotal,gift.monthTotal from giftrecordtotal gt " +
                " LEFT JOIN gift on gt.giftId = gift.seqId " +
                " where gt.giftid in ("+StringUtils.join(giftId,",")+") and gt.status = 1 order by gt.giftid ";
        final Map<String,Object> map = new HashMap<String, Object>();
        final List<Map<String,Object>> list = new ArrayList<Map<String, Object>>();
        getJdbcTemplate().query(sql,new Object[]{}, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("giftId");
                Map<String, Object> map = CollectionUtils.isEmpty(list)?null:list.get(list.size() - 1);

                if(map==null||!map.containsKey(id)){
                    map = new HashMap<String, Object>();
                    map.put("giftId",rs.getLong("giftId"));
                    map.put("OdayTotal",rs.getInt("dayTotal"));
                    map.put("OweekTotal",rs.getInt("weekTotal"));
                    map.put("OmonthTotal",rs.getInt("monthTotal"));
                    map.put("total",rs.getInt("total"));
                    map.put("leftNm",rs.getInt("leftNm"));
                    list.add(map);
                }
                addMap(rs,map);
            }
        } );
        covert(list,map);
        return map;
    }

    private void covert(List<Map<String,Object>> list ,Map<String,Object> map){
        for(Map<String,Object> innerMap : list){
            map.put(innerMap.get("giftId").toString(),innerMap);
            if(!innerMap.containsKey("dayTotal")){
                innerMap.put("dayTotal",0);
            }

            if(!innerMap.containsKey("weekTotal")){
                innerMap.put("weekTotal",0);
            }

            if(!innerMap.containsKey("monthTotal")){
                innerMap.put("monthTotal",0);
            }
        }
    }

    private void addMap(ResultSet rs , Map<String,Object> map) throws SQLException {
        String keyCode = rs.getString("keyCode");
        if(keyCode.equalsIgnoreCase("dayTotal")){
            map.put("dayTotal",rs.getInt("keyValue"));

        }else if(keyCode.equalsIgnoreCase("weekTotal")){
            map.put("weekTotal",rs.getInt("keyValue"));

        }else if(keyCode.equalsIgnoreCase("monthTotal")){
            map.put("monthTotal",rs.getInt("keyValue"));
        }
    }
}
