package com.xunlei.niux.data.newGift.bo;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.newGift.vo.GiftExchargeRecord;

import java.util.List;
import java.util.Map;

/**
 * Created by zy on 2016/4/11.
 */
public interface GiftExchargeRecordBo {
    /**
     *
     * @param ip        用户的IP地址
     * @param giftId    指定的礼包
     * @return          返回该IP地址领取该礼包的数量
     */
    int getCountByIP(String ip,long giftId);


    /**
     *
     * @param userId    用户的Id
     * @param giftId    指定的礼包Id
     * @return  返回该用户领取该礼包的数量
     */
    int getCountByUserId(String userId,long giftId);


    /**
     *
     * @param userId    用户id
     * @param actNo     活动编码
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param pageSize  页面大小
     * @param pageNo    第几页
     * @return          返回该活动的领取记录
     */
    List<GiftExchargeRecord> getActRecords(String userId, String actNo ,String startTime , String endTime ,int pageSize,int pageNo);

    /**
     *
     * @param userId    用户id
     * @param actNo     活动编码
     * @param giftId    礼包Id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param pageSize  页面大小
     * @param pageNo    第几页
     * @return          返回该活动的领取记录
     */
    List<GiftExchargeRecord> getActRecords(String userId, String actNo,Long giftId,String startTime,String endTime,int pageSize,int pageNo);


    /**
     *
     * @param userId    用户id
     * @param actNo     活动编码
     * @param giftId    礼包Id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return          返回该活动的领取记录
     */
    int getActRecordsCount(String userId, String actNo,Long giftId,String startTime,String endTime);

    /**
     * 根据登录人获取相关的礼包接口
     * @return
     */
    List<GiftExchargeRecord> getGiftRecordsByLogin(GiftExchargeRecord record, Page page , String login);

    /**
     * 根据登录人获取礼包的总数
     * @return
     */
    int countGiftRecordsByLogin(GiftExchargeRecord record ,String login);


    /**
     *
     * @param actNo
     * @return 根据活动编号查找运营添加的和用户领取的实物
     */
    List<GiftExchargeRecord> getRecords4Move(String actNo);


    /**
     *
     * @param record                要查询的记录信息
     * @param actNos                活动编号
     * @param page                  分页
     * @param outResourceType       不包含的资源类型
     * @return                      返回相应类型的结果集
     */
    List<GiftExchargeRecord> getGiftRecords4ActNos(GiftExchargeRecord record,String type, String actNos , Page page,String outResourceType);

    /**
     * @param record                要查询的记录信息
     * @param actNos                 活动编号
     * @param outResourceType       不包含的资源类型
     * @return                      返回相应类型的结果集的总数量
     */
    int getGiftRecordsCount4ActNos(GiftExchargeRecord record, String type, String actNos,String outResourceType );


    /**
     *
     * @param giftId                礼包的id数组
     * @return                      主键为giftId的map接口数据
     */
    Map<String,Object> getGiftStatisticsData(Long ... giftId);


    /**
     * 更新当前时间的改type下的领取数量
     * @param type          更新统计类型
     * @param giftId        要更新的giftId
     */
    void addStatisticsLeftNm(final String type,final String keyCode,final Long giftId);

}
