package com.xunlei.niux.data.newGift.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * 属性文件加载
 * Created by zy on 2016/3/28.
 */
public class PropertiesUtils {

    private static Properties prop = new Properties();
    private static Logger log = LoggerFactory.getLogger(PropertiesLoaderUtils.class);

    static {
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("hosts.properties");
        try {
            prop.load(resourceAsStream);
        } catch (IOException e) {
            log.error("load properties[hosts.properties] has error");
            throw new RuntimeException("load properties[hosts.properties] has error");
        }

    }

    public static Object get(String name ){
       return prop.get(name);
    }

}
