package com.xunlei.niux.data.newGift.util;

import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.ClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by zy on 2016/3/28.
 */
public class HttpClientUtil {

    private static Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static HttpClient client = new DefaultHttpClient();
    private static HttpClientUtil clientUtil = new HttpClientUtil();
    private HttpClientUtil(){}

    public static  HttpClientUtil getClientUtil(){
        return clientUtil;
    }

    public String getContentByGetUTF8(String url,Map<String,String> param){
        return getContentByGet(url,param,"utf-8");
    }

    public String getContentByGet(String url, Map<String,String> param,String defaultCharset ){
        HttpGet httpget = null;
        String result = null;

        if(param!=null&&!param.isEmpty()){
            url = url.indexOf("?")>-1?url:url+"?";
            Set<String> keys = param.keySet();
            for(String key : keys){
                url +="&"+key+"="+param.get(key);
            }
        }

        try {
            httpget = new HttpGet(url);
            HttpResponse e = client.execute(httpget);
            HttpEntity entity = e.getEntity();
            result = EntityUtils.toString(entity, defaultCharset);

            log.info("send URL {}\nreceive request {} ",new Object []{url,result});

            return result;
        } catch (Exception e) {
            log.error("httpGet -ERROR- url:{}", new Object[]{url, e});
        } finally {
            log.info("httpget url:{},result:{}", new Object[]{url, result});
            httpget.abort();
        }
        return null;
    }

    public String getContentByPostUTF8(String url , Map<String,String> param,Map<String,String> cookieMap){
        return getContentByPost(url,param,"utf-8",cookieMap);
    }

    public String getContentByPostUTF8(String url , Map<String,String> param){
        return getContentByPost(url,param,"utf-8",null);
    }

    public String getContentByPost(String url, Map<String,String> param, String defaultCharset,Map<String,String> cookieMap){
        HttpPost httpPost = null;
        String result = null;

        List<NameValuePair> nvps = new ArrayList<NameValuePair>();
        if(param!=null&&!param.isEmpty()){
            Set<String> keys = param.keySet();
            for(String key : keys){
                nvps.add(new BasicNameValuePair(key,param.get(key)));
            }
        }
        try {
            CookieStore store = new BasicCookieStore();
            store.addCookie(new BasicClientCookie("sessionid",cookieMap.get("sessionid")));
            httpPost = new HttpPost(url);
            if(cookieMap!=null&&!cookieMap.isEmpty()){
                Set<String> keys = cookieMap.keySet();
                StringBuilder sb = new StringBuilder();
                for(String key : keys){
                    sb.append(key+"="+cookieMap.get(key)+";");
                }
                httpPost.setHeader("Cookie",sb.toString());
            }

            httpPost.setEntity(new UrlEncodedFormEntity(nvps));
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = client.execute(httpPost);
            result = EntityUtils.toString(response.getEntity(), defaultCharset);

            log.info("send URL {}\r\nsend param {} \r\n receive request {} ",new Object []{url,param!=null?param.toString():"null",result});
            return result;
        } catch (Exception e) {
            log.error("httpPost -ERROR- url:{}", new Object[]{url, e});
        } finally {
            log.info("httpPost url:{},result:{}", new Object[]{url, result});
            httpPost.abort();
        }
        return null;
    }

    public Boolean getRtn(String url,Map<String,String> param){
        JSONObject object = getJsonObjectByGet(url, param);
        Object rtn = null;
        try {
            rtn = object.get("rtn");
        } catch (JSONException e) {
            log.error("have no field rtn");
            return false;
        }
        return rtn.equals("0")?true:false;
    }

    public JSONObject getJsonObjectByGet(String url,Map<String,String> param){
        String content = getContentByGetUTF8(url, param);
        try {
            JSONObject object = new JSONObject(content);
            return object;

        } catch (JSONException e) {
            log.error("content is not standard json: {}",new Object[]{content});
        }
        return null;
    }

    public JSONObject getJsonObjectByPost(String url,Map<String,String> param){
        String content = getContentByPostUTF8(url, param);
        try {
            JSONObject object = new JSONObject(content);
            return object;

        } catch (JSONException e) {
            log.error("content is not standard json: {}",new Object[]{content});
        }
        return null;
    }

    public JSONObject getJsonObjectByPost(String url,Map<String,String> param,Map<String,String > cookieMap,boolean isJsonp){
        String content = getContentByPostUTF8(url, param,cookieMap);
        try {
            if(isJsonp){
                content = content.substring(content.indexOf("(")+1);
                content = content.substring(0,content.lastIndexOf(")"));
            }
            JSONObject object = new JSONObject(content);
            return object;

        } catch (JSONException e) {
            log.error("content is not standard json: {}",new Object[]{content});
        }
        return null;
    }

    public JSONObject getJsonObjectByPost(String url,Map<String,String> param,Map<String,String > cookieMap){
        return getJsonObjectByPost(url,param,cookieMap,false);
    }
}
