package com.xunlei.niux.data.newGift.conditions;

import com.xunlei.niux.data.newGift.conditions.exception.XLConditionException;
import com.xunlei.niux.data.newGift.util.PropertiesUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zy on 2016/3/29.
 */
public class UserInfoCondition implements IConditions {

    private static final String userInfoUrl = PropertiesUtils.get("userInfo").toString();
    private static Logger LOGGER = LoggerFactory.getLogger(UserInfoCondition.class);

    @Override
    public boolean check(String startValue, String endValue, String gameid, String serverid, String userid,
                         String username,String toJsonObjectEL,String fields,String url,String rtnel, String... cookies) throws XLConditionException {
        Map<String,String > cookieMap = new HashMap<String, String>();
        cookieMap.put("userid",userid);
        cookieMap.put("sessionid",cookies[0]);
        cookieMap.put("seccode",cookies[1]);
        JSONObject jsonObject = clientUtil.getJsonObjectByPost(userInfoUrl, null,cookieMap,true);

        try {
            if((Integer)jsonObject.get("rtn")!=0){
                return false;
            }
            System.out.println(jsonObject.toString());
            return true;
        } catch (JSONException e) {
            LOGGER.error("get content [ data ] is not json:"+e.getMessage());
            throw  new XLConditionException("get content [ data ] is not json : "+e.getMessage());
        }
    }
}
