/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.newGift.dao.GiftDao;
import com.xunlei.niux.data.newGift.vo.Gift;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowCallbackHandler;

public class GiftDaoImpl
extends BaseDaoImpl
implements GiftDao {
    @Override
    public Map<String, Object> getGiftMap(String actNo, int modelNo) {
        String sql = "select * from gift\nLEFT JOIN giftextinfo on gift.seqid = giftextinfo.giftId\nwhere actNo=? and modelNo=? and gift.status = ?\nORDER BY gift.seqId DESC ,giftextinfo.type ,giftextinfo.seqId DESC";
        final HashMap<String, Object> map = new HashMap<String, Object>();
        this.getJdbcTemplate().query(sql, new Object[]{actNo, modelNo, 1}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                if (!map.containsKey("giftId")) {
                    map.put("giftId", rs.getString("seqId"));
                    map.put("giftName", rs.getString("giftname"));
                    map.put("modelNo", rs.getString("modelNo"));
                    map.put("advNo", rs.getString("advNo"));
                    map.put("startTime", rs.getString("startTime"));
                    map.put("endTime", rs.getString("endTime"));
                    map.put("total", rs.getString("total"));
                    map.put("leftNm", rs.getString("leftNm"));
                    map.put("orderNo", rs.getString("orderNo"));
                    map.put("extInfo", new ArrayList());
                }
                HashMap<String, String> extInfoMap = new HashMap<String, String>();
                extInfoMap.put("type", rs.getString("type"));
                extInfoMap.put("keyCode", rs.getString("keyCode"));
                extInfoMap.put("keyValue", rs.getString("keyValue"));
                ((List)map.get("extInfo")).add(extInfoMap);
            }
        });
        return map;
    }

    @Override
    public Gift getGiftByLock(long id) {
        String sql = "select * from gift where seqId = ?  for update";
        ArrayList<Long> param = new ArrayList<Long>();
        param.add(id);
        List bySql = this.findBySql(Gift.class, sql, param);
        return bySql == null || bySql.size() == 0 ? null : (Gift)bySql.get(0);
    }

    @Override
    public List<Map<String, Object>> getExtGifts(String actNo, int size) {
        String sql = "SELECT gtmp.seqId, gtmp.giftName,gtmp.modelNo,gtmp.orderNo,gei.type,gei.keyCode,gei.keyValue,gei.status,gtmp.startTime,gtmp.endTime,gtmp.total,gtmp.leftNm,gtmp.advNo,gtmp.actNo from \n(SELECT gift.seqId, gift.giftName,gift.modelNo,gift.orderNo,gift.advNo,gift.actNo,gift.startTime,gift.endTime,gift.total,gift.leftNm FROM gift  INNER JOIN \n                (SELECT  max(orderNo) as orderNo,modelNo,actNo  from gift  where actNo= ? and status =1 \n                 and startTime < NOW() and endTime > NOW() group by modelNo order by modelNo ) g  \n                on gift.actNo = g.actNo and gift.modelNo = g.modelNo and gift.orderNo = g.OrderNo limit ? ) gtmp \nleft join giftextinfo gei on gtmp.seqid = gei.giftid order by gtmp.modelNo ,gtmp.orderNo,gei.seqid   ";
        final ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.getJdbcTemplate().query(sql, new Object[]{actNo, size}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long seqid = rs.getLong("seqId");
                Map<String, Object> map = list.size() == 0 ? null : (Map)list.get(list.size() - 1);
                Long mapSeqId = map == null || map.get("seqId") == null ? 0L : (Long)map.get("seqId");
                if (mapSeqId != seqid) {
                    map = new HashMap<String, Object>();
                    list.add(map);
                    map.put("seqId", rs.getLong("seqId"));
                    map.put("giftName", rs.getString("giftName"));
                    map.put("giftId", rs.getString("seqId"));
                    map.put("actNo", rs.getString("actNo"));
                    map.put("modelNo", rs.getString("modelNo"));
                    map.put("advNo", rs.getString("advNo"));
                    map.put("startTime", rs.getString("startTime"));
                    map.put("endTime", rs.getString("endTime"));
                    map.put("total", rs.getString("total"));
                    map.put("leftNm", rs.getString("leftNm"));
                    map.put("orderNo", rs.getString("orderNo"));
                    map.put("extInfo", new ArrayList());
                }
                HashMap<String, String> extInfoMap = new HashMap<String, String>();
                extInfoMap.put("type", rs.getString("type"));
                extInfoMap.put("keyCode", rs.getString("keyCode"));
                extInfoMap.put("keyValue", rs.getString("keyValue"));
                ((List)map.get("extInfo")).add(extInfoMap);
            }
        });
        return list;
    }

    @Override
    public List<Gift> getGiftsByActNo(String actNo, int size) {
        String sql = "select * from gift where actNo=? and `status`=1 and startTime<=NOW() and endTime >= NOW() order by orderNo desc limit ? \n";
        ArrayList<Object> param = new ArrayList<Object>(2);
        param.add(actNo);
        param.add(size);
        List gifts = this.findBySql(Gift.class, sql, param);
        return gifts;
    }

    @Override
    public List<Map<String, Object>> getMobileWeekGifts(String actNo, int size) {
        String sql = "SELECT gift.seqId, gift.giftName,gift.modelNo,gift.orderNo FROM gift  INNER JOIN \n(SELECT  max(orderNo) as orderNo,modelNo,actNo  from gift  where actNo= ? and status =1 and startTime < NOW() and endTime > NOW() group by modelNo order by modelNo ) g \non gift.actNo = g.actNo and gift.modelNo = g.modelNo and gift.orderNo = g.OrderNo order by modelNo  LIMIT ? \n";
        final ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.getJdbcTemplate().query(sql, new Object[]{actNo, size}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("giftId", rs.getLong("seqId"));
                map.put("giftName", rs.getString("giftname"));
                map.put("orderNo", rs.getInt("orderNo"));
                map.put("modelNo", rs.getInt("modelNo"));
                list.add(map);
            }
        });
        return list;
    }
}

