/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.newGift.conditions;

import com.xunlei.niux.data.newGift.conditions.IConditions;
import com.xunlei.niux.data.newGift.conditions.exception.XLConditionException;
import java.util.HashMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionCheck
implements IConditions {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionCheck.class);

    @Override
    public boolean check(String startValue, String endValue, String gameid, String serverid, String userid, String username, String toJsonObjectEL, String fields, String url, String rtnel, String ... cookies) throws XLConditionException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userid", userid);
        param.put("gameid", gameid);
        param.put("serverid", serverid);
        HashMap<String, String> cookiesMap = new HashMap<String, String>();
        if (cookies != null && cookies.length > 0) {
            cookiesMap.put("sessionid", cookies[0]);
            cookiesMap.put("secode", cookies[1]);
            cookiesMap.put("userid", userid);
        }
        url = url + "?callback=jQuery" + System.nanoTime();
        String content = clientUtil.getContentByPost(url, param, "utf-8", cookiesMap);
        String json = this.str2json(toJsonObjectEL, content);
        String fieldValue = this.getFieldValue(rtnel, fields, json);
        return this.getFlag(startValue, endValue, fieldValue);
    }

    private String str2json(String toJsonObjectEL, String content) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        try {
            if (toJsonObjectEL.toLowerCase().indexOf("function") > -1) {
                Compilable compilable = (Compilable)((Object)engine);
                Bindings bindings = engine.createBindings();
                CompiledScript JSFunction = compilable.compile(toJsonObjectEL);
                bindings.put("content", (Object)content);
                return JSFunction.eval(bindings).toString();
            }
            engine.put("content", content);
            return engine.eval(toJsonObjectEL).toString();
        }
        catch (Exception e) {
            LOGGER.error("js expression has error !\n [error]:" + e.getMessage());
            return "";
        }
    }

    private String getFieldValue(String rtnel, String fields, String json) {
        try {
            String[] field;
            JSONObject jsonObject = new JSONObject(json);
            if (StringUtils.isNotEmpty((String)rtnel)) {
                int rtn;
                String[] split = rtnel.split("=");
                if (split.length != 2) {
                    LOGGER.error("rtn el has error [rtn] : " + rtnel);
                }
                if ((rtn = Integer.valueOf(jsonObject.get(split[0]).toString()).intValue()) != Integer.valueOf(split[1])) {
                    return "-100";
                }
            }
            if (StringUtils.isEmpty((String)fields)) {
                LOGGER.error("field is need !");
            }
            for (String f : field = fields.split("\\.")) {
                if (f == field[field.length - 1]) {
                    return jsonObject.get(f).toString();
                }
                jsonObject = (JSONObject)jsonObject.get(f);
            }
            LOGGER.error("no found this field ,please check ! ");
        }
        catch (JSONException e) {
            LOGGER.error("field is need !");
        }
        return "";
    }

    private boolean getFlag(String startValue, String endValue, String fieldValue) {
        double start = Double.valueOf(startValue);
        double end = Double.valueOf(endValue);
        double value = Double.valueOf(fieldValue);
        if (end == -1.0) {
            return value > start;
        }
        return value >= start && value <= end;
    }
}

