package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.newGift.vo.GiftBonus;
import com.xunlei.niux.data.newGift.vo.GiftBonusTotal;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zy on 2016/6/22.
 */
public class GiftBonusTotalDaoImpl extends BaseDaoImpl implements GiftBonusTotalDao {

    @Override
    public Map<String, String> takeOffBonus(GiftBonus giftBonus) {
        Map<String,String> map = new HashMap<String, String>(2);

        if(null==giftBonus){
            map.put("rtn","-33");
            map.put("data","参数有误");
            return map;
        }

        if(StringUtils.isNotEmpty(giftBonus.getTransNo())&&giftBonus.getTransNo().length()>25){
            map.put("rtn","-34");
            map.put("data","交易编号不能超过25个字符");
            return map;
        }

        String sql = "select * from giftbonustotal where userId = ? and actNo= ? and bonusType = ? for update ";
        List<Object> param = new ArrayList<Object>(3);
        param.add(giftBonus.getUserId());
        param.add(giftBonus.getActNo());
        param.add(giftBonus.getBonusType());
        List<GiftBonusTotal> bonusTotals = findBySql(GiftBonusTotal.class, sql, param);
        if(CollectionUtils.isEmpty(bonusTotals)){
            map.put("rtn","-31");
            map.put("data",giftBonus.getBonusType()+"不足");
            return map;
        }
        GiftBonusTotal total = bonusTotals.get(0);
        if(total.getBonusTotal()<giftBonus.getBonus()){
            map.put("rtn","-32");
            map.put("data",giftBonus.getBonusType()+"不足"+giftBonus.getBonus());
            return map;
        }
        insert(giftBonus);

        total.setBonusTotal(total.getBonusTotal()-giftBonus.getBonus());
        total.setEditTime(DateUtil.getOrderTime());
        updateById(total);
        return null;
    }

    @Override
    public Map<String, String> returnConsume(GiftBonus giftBonus) {
        Map<String,String> map = new HashMap<String, String>(2);
        String ip = giftBonus.getIp();
        String sql = "select * from giftbonus where userId = ? and actNo= ? and bonusType = ? and transNo = ? limit 1 for update ";
        List<Object> param = new ArrayList<Object>();
        param.add(giftBonus.getUserId());
        param.add(giftBonus.getActNo());
        param.add(giftBonus.getBonusType());
        param.add(giftBonus.getTransNo());
        List<GiftBonus> giftBonuses = findBySql(GiftBonus.class, sql, param);
        if(CollectionUtils.isEmpty(giftBonuses)){
            map.put("rtn","-35");
            map.put("data","没有该订单");
            return map;
        }

        giftBonus = giftBonuses.get(0);
        if(giftBonus.getOperate().intValue()<0){
            map.put("rtn","-36");
            map.put("data","不能重复回滚");
            return map;
        }

        if(giftBonus.getOperate().intValue()==3){
            map.put("rtn","-37");
            map.put("data","回滚记录不能回滚");
            return map;
        }
        Integer operate = giftBonus.getOperate();

        //更新原记录的状态为负数
        giftBonus.setOperate(0-giftBonus.getOperate());
        updateById(giftBonus);


        giftBonus.setOperate(3);                    //标记该动作为回滚
        giftBonus.setRemark(giftBonus.getTransNo());
        giftBonus.setTransNo(OrderNoUtil.getOrderNo());
        giftBonus.setIp(ip);
        giftBonus.setStatus(1);
        giftBonus.setAddTime(DateUtil.getOrderTime());

        GiftBonusTotal total = new GiftBonusTotal();
        total.setStatus(1);
        total.setBonusType(giftBonus.getBonusType());
        total.setActNo(giftBonus.getActNo());
        total.setUserId(giftBonus.getUserId());
        Page page = new Page(1,1);
        List<GiftBonusTotal> bonusTotals = findByObject(GiftBonusTotal.class, total, page);

        total = bonusTotals.get(0);
        total.setEditTime(DateUtil.getOrderTime());

        if(operate.intValue()==1){
            //如果原操作为发放积分
            giftBonus.setBonus(0-giftBonus.getBonus());
        }else if(operate.intValue()==2){
            //如果原操作为扣除积分
            giftBonus.setBonus(giftBonus.getBonus());
        }
        total.setBonusTotal(total.getBonusTotal()+giftBonus.getBonus());
        if(total.getBonusTotal()<0){
            //回滚出现负数，把结果调整为0，并把负数记录在remark里面
            giftBonus.setRemark(giftBonus.getRemark()+":"+total.getBonusTotal());
            total.setBonusTotal(0);
        }
        updateById(total);
        insert(giftBonus);
        return null;
    }
}
