package com.xunlei.niux.data.newGift.conditions;

import com.xunlei.niux.data.newGift.conditions.exception.XLConditionException;
import com.xunlei.niux.data.newGift.util.HttpClientUtil;
import com.xunlei.niux.data.newGift.util.PropertiesUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zy on 2016/3/28.
 */
public class LevelCondition implements IConditions {

    private static String userLevel = (String) PropertiesUtils.get("userLevel");
    private static Logger log = LoggerFactory.getLogger(LevelCondition.class);

    @Override
    public boolean check(String startValue, String endValue, String gameid, String serverid, String userid,
                         String username,String toJsonObjectEL,String fields,String url,String rtnel, String... cookies) throws XLConditionException {
        Map<String,String> param = new HashMap<String, String>();
        param.put("userid",userid);
        param.put("gameid",gameid);
        param.put("serverid",serverid);
        JSONObject jsonObject = clientUtil.getJsonObjectByPost(userLevel, param);

            try {
                if((Integer)jsonObject.get("rtn")!=0){
                    return false;
                }
                JSONObject data = (JSONObject) jsonObject.get("data");
                int level = data.getInt("level");
                int start = Integer.valueOf(startValue);
                int end = Integer.valueOf(endValue);

                if(end==-1) {
                    return level>=start;
                }else{
                    return level>=start&&level<=end;
                }
            } catch (JSONException e) {
                log.error("get content [ data ] is not json:"+e.getMessage());
                throw  new XLConditionException("get content [ data ] is not json : "+e.getMessage());
            }
    }
}
