/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.newGift.dao.ResourcesDao;
import com.xunlei.niux.data.newGift.dto.GiftResourcesDTO;
import com.xunlei.niux.data.newGift.vo.Resources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ResourcesDaoImpl
extends BaseDaoImpl
implements ResourcesDao {
    @Override
    public List<GiftResourcesDTO> getResourcesByGift(String giftId, String seqId) {
        String sql = "SELECT r.seqId,r.resourceName,gr.total,gr.seqId as grId,gr.proportion,gr.leftNm,r.resourceType \nfrom resources  r\nINNER JOIN giftresource gr on r.seqId = gr.resourceId \nWHERE r.`status` =1 AND gr.giftId=? ";
        ArrayList<String> param = new ArrayList<String>();
        param.add(giftId);
        if (StringUtils.isNotEmpty((String)seqId)) {
            sql = sql + " and r.seqId =? ";
            param.add(seqId);
        }
        sql = sql + " order by r.editTime desc ";
        return this.findBySql(GiftResourcesDTO.class, sql, param);
    }

    @Override
    public List<Resources> getResourcesNotByGift(String giftId, String seqId) {
        String sql = "SELECT *  from resources r   where not  EXISTS (  SELECT 1 from giftresource gr where  gr.resourceId = r.seqId and gr.giftId = ?) and status =1  ";
        ArrayList<String> param = new ArrayList<String>();
        param.add(giftId);
        if (StringUtils.isNotEmpty((String)seqId)) {
            sql = sql + " and r.seqId =? ";
            param.add(seqId);
        }
        sql = sql + " order by r.editTime desc ";
        return this.findBySql(Resources.class, sql, param);
    }

    @Override
    public List<Resources> getResourceByBath(String bathIds) {
        String sql = "select * from resources r where r.seqid in ( " + bathIds + " ) and status = 1 ";
        return this.findBySql(Resources.class, sql, Collections.emptyList());
    }
}

