/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.newGift.dao.GiftExchargeRecordDao;
import com.xunlei.niux.data.newGift.vo.GiftAct;
import com.xunlei.niux.data.newGift.vo.GiftExchargeRecord;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GiftExchargeRecordDaoImpl
extends BaseDaoImpl
implements GiftExchargeRecordDao {
    @Override
    public int getCountByIP(String ip, long giftId) {
        String sql = "select count(*) from giftexchargerecord where ip =? and giftId =?  and status =1 ";
        return this.getJdbcTemplate().queryForInt(sql, new Object[]{ip, giftId});
    }

    @Override
    public int getCountByUserId(String userId, long giftId) {
        String sql = "select count(*) from giftexchargerecord where userId =? and giftId =? AND status =1 ";
        return this.getJdbcTemplate().queryForInt(sql, new Object[]{userId, giftId});
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo, String startTime, String endTime, int pageSize, int pageNo) {
        return this.getActRecords(userId, actNo, 0L, startTime, endTime, pageSize, pageNo);
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo, Long giftId, String startTime, String endTime, int pageSize, int pageNo) {
        String sql = " select SUBSTRING(recordTime,1,19) as recordTime,giftexchargerecord.* from  giftexchargerecord where userId = ? and status = 1  ";
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(userId);
        if (StringUtils.isNotEmpty((String)actNo)) {
            param.add(actNo);
            sql = sql + " and actNo = ? ";
        }
        if (giftId > 0L) {
            param.add(giftId);
            sql = sql + " and giftId  = ? ";
        }
        if (StringUtils.isNotEmpty((String)startTime)) {
            param.add(startTime);
            sql = sql + " and recordTime >= ?";
        }
        if (StringUtils.isNotEmpty((String)endTime)) {
            param.add(endTime);
            sql = sql + " and recordTime <= ?";
        }
        sql = sql + " order by recordTime desc ";
        if (pageNo > 0 && pageSize > 0) {
            sql = sql + " limit " + (pageNo - 1) * pageSize + "," + pageSize;
        } else if (pageSize > 0) {
            sql = sql + " limit " + pageSize;
        }
        return this.findBySql(GiftExchargeRecord.class, sql, param);
    }

    @Override
    public List<GiftExchargeRecord> getGiftRecordsByLogin(GiftExchargeRecord record, Page page, String login) {
        GiftAct act = new GiftAct();
        act.setActStaff(login);
        act.setStatus(1);
        Page page1 = new Page();
        page1.addOrder("isAdmin", OrderType.DESC);
        List byObject = this.findByObject(GiftAct.class, act, page1);
        if (byObject == null || byObject.size() == 0) {
            return null;
        }
        if (((GiftAct)byObject.get(0)).getIsAdmin() == 1) {
            return this.findByObject(GiftExchargeRecord.class, record, page);
        }
        String actNos = "";
        for (GiftAct act1 : byObject) {
            actNos = actNos + "'" + act1.getActNo() + "',";
        }
        actNos = actNos.substring(0, actNos.length() - 1);
        ArrayList<Object> list = new ArrayList<Object>();
        String sql = "select * from giftexchargerecord ger where 1=1 ";
        sql = sql + this.getConditon(record, list, actNos);
        sql = sql + " order by ger.recordTime desc ";
        if (page.getPageNo() <= 0) {
            page.setPageNo(1);
        }
        sql = sql + " limit " + (page.getPageNo() - 1) * page.getPageSize() + ", " + page.getPageSize();
        List giftExchargeRecords = this.findBySql(GiftExchargeRecord.class, sql, list);
        return giftExchargeRecords;
    }

    @Override
    public int countGiftRecordsByLogin(GiftExchargeRecord record, String login) {
        GiftAct act = new GiftAct();
        act.setStatus(1);
        act.setActStaff(login);
        Page page1 = new Page();
        page1.addOrder("isAdmin", OrderType.DESC);
        List byObject = this.findByObject(GiftAct.class, act, page1);
        if (byObject == null || byObject.size() == 0) {
            return 0;
        }
        if (((GiftAct)byObject.get(0)).getIsAdmin() == 1) {
            return this.count(record);
        }
        String actNos = "";
        for (GiftAct act1 : byObject) {
            actNos = actNos + "'" + act1.getActNo() + "',";
        }
        actNos = actNos.substring(0, actNos.length() - 1);
        ArrayList<Object> list = new ArrayList<Object>();
        String sql = "select count(*) from giftexchargerecord ger where 1=1 " + this.getConditon(record, list, actNos);
        return this.getJdbcTemplate().queryForInt(sql, list.toArray());
    }

    private String getConditon(GiftExchargeRecord record, List<Object> list, String actNos) {
        String sql = "";
        if (record.getSeqId() != null && record.getSeqId() > 0L) {
            sql = sql + " and ger.seqId = ? ";
            list.add(record.getSeqId());
        }
        if (record.getUserId() != null && record.getUserId() > 0L) {
            sql = sql + " and ger.userId = ? ";
            list.add(record.getUserId());
        }
        if (StringUtils.isNotEmpty((String)record.getActNo())) {
            sql = sql + " and ger.actNo = ? ";
            list.add(record.getActNo());
        }
        if (record.getGiftId() != null && record.getGiftId().intValue() > 0) {
            sql = sql + " and ger.giftId = ? ";
            list.add(record.getGiftId());
        }
        if (StringUtils.isNotEmpty((String)record.getActNm())) {
            sql = sql + " and ger.actNm = ? ";
            list.add(record.getActNm());
        }
        if (StringUtils.isNotEmpty((String)record.getGiftNm())) {
            sql = sql + " and ger.giftNm = ? ";
            list.add(record.getGiftNm());
        }
        if (StringUtils.isNotEmpty((String)record.getFromRecordTime())) {
            sql = sql + " and ger.recordTime >= ? ";
            list.add(record.getFromRecordTime());
        }
        if (StringUtils.isNotEmpty((String)record.getEndRecordTime())) {
            sql = sql + " and ger.recordTime <= ? ";
            list.add(record.getEndRecordTime());
        }
        if (record.getStatus() != null && record.getStatus() > -1) {
            sql = sql + " and ger.status = ? ";
            list.add(record.getStatus());
        }
        if (actNos.length() > 1) {
            sql = sql + " and actNo in (" + actNos + ") ";
        }
        return sql;
    }

    @Override
    public List<GiftExchargeRecord> getRecords4Move(String actNo) {
        String sql = "select ger.* from giftexchargerecord ger  left join resources r on ger.resourceId = r.seqId   where r.resourceType='product' and ger.actNo='" + actNo + "' and  ger.status in (1,2)" + " order by recordTime desc ";
        List bySql = this.findBySql(GiftExchargeRecord.class, sql, new ArrayList());
        return bySql;
    }

    @Override
    public int getActRecordsCount(String userId, String actNo, Long giftId, String startTime, String endTime) {
        String sql = " select COUNT(*)  from  giftexchargerecord where userId = ? and status = 1  ";
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(userId);
        if (StringUtils.isNotEmpty((String)actNo)) {
            param.add(actNo);
            sql = sql + " and actNo = ? ";
        }
        if (giftId > 0L) {
            param.add(giftId);
            sql = sql + " and giftId  = ? ";
        }
        if (StringUtils.isNotEmpty((String)startTime)) {
            param.add(startTime);
            sql = sql + " and recordTime >= ?";
        }
        if (StringUtils.isNotEmpty((String)endTime)) {
            param.add(endTime);
            sql = sql + " and recordTime <= ?";
        }
        return this.getJdbcTemplate().queryForInt(sql, param.toArray());
    }

    @Override
    public List<GiftExchargeRecord> getGiftRecords4ActNos(GiftExchargeRecord record, String type, String actNos, Page page, String outResourceType) {
        StringBuilder sql = new StringBuilder("select * from giftexchargerecord ger where 1=1   ");
        ArrayList param = new ArrayList();
        sql.append(this.getCondition4Type(record, param, actNos, type, outResourceType));
        sql.append("  order by ger.recordTime desc ");
        if (page != null) {
            if (page.getPageNo() <= 0) {
                page.setPageNo(1);
            }
            sql.append(" limit " + (page.getPageNo() - 1) * page.getPageSize() + ", " + page.getPageSize());
        }
        return this.findBySql(GiftExchargeRecord.class, sql.toString(), param);
    }

    @Override
    public int getGiftRecordsCount4ActNos(GiftExchargeRecord record, String type, String actNos, String outResourceType) {
        StringBuilder sql = new StringBuilder("select count(*) from giftexchargerecord ger  where 1 =1 ");
        ArrayList param = new ArrayList();
        sql.append(this.getCondition4Type(record, param, actNos, type, outResourceType));
        return this.getJdbcTemplate().queryForInt(sql.toString(), param.toArray());
    }

    private String getCondition4Type(GiftExchargeRecord record, List param, String actNos, String type, String outResourceType) {
        String result = this.getConditon(record, param, actNos);
        if (StringUtils.isNotEmpty((String)type)) {
            if (type.equals("product")) {
                result = result + " and  serialType = ? ";
                param.add(type);
            } else if (type.equals("vm")) {
                result = result + " and  serialType != ? ";
                param.add("product");
            } else if (type.equals("takeoff")) {
                result = result + " and  bonusType!=null and bonus > 0 ";
            }
        }
        if (StringUtils.isNotEmpty((String)outResourceType)) {
            result = result + " and serialType not in (" + outResourceType + ") ";
        }
        return result;
    }
}

