package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.newGift.dto.GiftConditionDTO;
import com.xunlei.niux.data.newGift.vo.Conditions;
import com.xunlei.niux.data.newGift.vo.GiftCondition;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zy on 2016/3/25.
 */
public class GiftConditionsDaoImpl extends BaseDaoImpl implements GiftConditonsDao {


    @Override
    public void addGiftConditions(long giftId, Long[] conditionIds) {
        if(conditionIds.length==0||giftId==0){
            return;
        }
        String sql = "select * from conditions where seqId in ( ";
        List<Conditions> conditionsList = null;
        List<Object> param = new ArrayList<Object>(conditionIds.length);
        for(int i = 0 ; i < conditionIds.length ; i++){
            param.add(conditionIds[i]);
            sql +="?,";
        }
        sql = sql.substring(0,sql.length()-1)+") and status =1 ";
        conditionsList = findBySql(Conditions.class, sql, param);
        if(conditionsList==null||conditionsList.size()==0){
            return;
        }
        Map<Long,Conditions> map = new HashMap<Long, Conditions>(conditionsList.size());
        for(Conditions c : conditionsList){
            map.put(c.getSeqId(),c);
        }

        for(Long id : conditionIds){
            Conditions c = map.get(id);
            GiftCondition giftCondition = new GiftCondition();
            giftCondition.setGiftId(giftId);
            giftCondition.setConditionId(id);
            giftCondition.setStartValue(c.getDefaultStartValue());
            giftCondition.setEndValue(c.getDefaultEndValue());
            giftCondition.setOrderNo(0);
            giftCondition.setRemark(c.getRemark());
            insert(giftCondition);
        }
    }

    @Override
    public void removeGiftConditions(long giftId, Long[] conditionIds) {
        if(conditionIds.length==0||giftId==0){
            return;
        }

        String sql = " delete from giftcondition where giftId = ?  and conditionId in (";

        List<Object> param = new ArrayList<Object>();
        param.add(giftId);
        for(Long id : conditionIds){
            sql += " ? ,";
            param.add(id);
        }
        sql = sql.substring(0,sql.length()-1)+")";
        execute(sql,param);
    }

}
