package com.xunlei.niux.data.newGift.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.newGift.dao.GiftResourcesDao;
import com.xunlei.niux.data.newGift.vo.GiftResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by zy on 2016/3/24.
 */
@Service
public class GiftResourcesBoImpl implements GiftResourcesBo {

    @Autowired
    private GiftResourcesDao giftResourcesDao;
    @Resource(name = "BaseDao")
    private BaseDao baseDao;

    @Override
    @Transactional
    public void addGiftResources(long giftId, Long[] resourcesId) {
        giftResourcesDao.addGiftResources(giftId,resourcesId);
    }

    @Override
    public void removeGiftResources(long giftId, Long[] resourcesId) {
        giftResourcesDao.removeGiftResources(giftId,resourcesId);
    }

    @Override
    @Transactional
    public Map<String,Object> takeOffGiftResourceNm(long seqId) {
        //扣除resource中的剩余数量
        GiftResource giftResource = giftResourcesDao.getLockGiftResource(seqId);
        Map<String,Object> map = new HashMap<String, Object>();
        if(giftResource.getLeftNm()<1){
            //// TODO: 2016/4/13  领取失败，再次领取
            map.put("rtn",-1);
            map.put("data","领取结束");
            return map;
        }
        giftResource.setLeftNm(giftResource.getLeftNm()-1);
        baseDao.updateById(giftResource);
        return map;
    }
}
