package com.xunlei.niux.data.newGift.bo;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.newGift.dao.GiftExchargeRecordDao;
import com.xunlei.niux.data.newGift.vo.GiftExchargeRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by zy on 2016/4/11.
 */

@Service
public class GiftExchargeRecordBoImpl implements GiftExchargeRecordBo {

    @Autowired
    private GiftExchargeRecordDao giftExchargeRecordDao;

    @Override
    public int getCountByIP(String ip, long giftId) {
        return giftExchargeRecordDao.getCountByIP(ip,giftId);
    }

    @Override
    public int getCountByUserId(String userId, long giftId) {
        return giftExchargeRecordDao.getCountByUserId(userId,giftId);
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo,String startTime,String endTime,int pageSize,int pageNo) {
        return giftExchargeRecordDao.getActRecords(userId,actNo,startTime,endTime,pageSize,pageNo);
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo, Long giftId, String startTime, String endTime, int pageSize, int pageNo) {
        return giftExchargeRecordDao.getActRecords(userId,actNo,giftId,startTime,endTime,pageSize,pageNo);
    }

    @Override
    public List<GiftExchargeRecord> getGiftRecordsByLogin(GiftExchargeRecord record, Page page, String login) {
        return giftExchargeRecordDao.getGiftRecordsByLogin(record,page,login);
    }

    @Override
    public int countGiftRecordsByLogin(GiftExchargeRecord record, String login) {
        return giftExchargeRecordDao.countGiftRecordsByLogin(record,login);
    }

    @Override
    public List<GiftExchargeRecord> getRecords4Move(String actNo) {
        return giftExchargeRecordDao.getRecords4Move(actNo);
    }

    @Override
    public int getActRecordsCount(String userId, String actNo, Long giftId, String startTime, String endTime) {
        return giftExchargeRecordDao.getActRecordsCount(userId,actNo,giftId,startTime,endTime);
    }

    @Override
    public List<GiftExchargeRecord> getGiftRecords4ActNos(GiftExchargeRecord record, String type, String actNos, Page page,String outResourceType) {
        return giftExchargeRecordDao.getGiftRecords4ActNos(record,type,actNos,page,outResourceType);
    }

    @Override
    public int getGiftRecordsCount4ActNos(GiftExchargeRecord record, String type, String actNos,String outResourceType) {
        return giftExchargeRecordDao.getGiftRecordsCount4ActNos(record,type,actNos,outResourceType);
    }
}
