package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.newGift.dto.GiftResourcesDTO;
import com.xunlei.niux.data.newGift.vo.Resources;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by zy on 2016/3/23.
 */
public class ResourcesDaoImpl extends BaseDaoImpl implements ResourcesDao {


    @Override
    public List<GiftResourcesDTO> getResourcesByGift(String giftId, String seqId) {
        String sql = "SELECT r.seqId,r.resourceName,gr.total,gr.seqId as grId,gr.proportion,gr.leftNm," +
                     "r.resourceType \n" +
                     "from resources  r\n" +
                     "INNER JOIN giftresource gr on r.seqId = gr.resourceId \n" +
                     "WHERE r.`status` =1 AND gr.giftId=? ";
        List<Object> param = new ArrayList<Object>();
        param.add(giftId);

        if(StringUtils.isNotEmpty(seqId)){
            sql += " and r.seqId =? ";
            param.add(seqId);
        }
        sql +=" order by r.editTime desc ";
        return findBySql(GiftResourcesDTO.class,sql,param);
    }

    @Override
    public List<Resources> getResourcesNotByGift(String giftId,String seqId) {
        String sql = "SELECT *  from resources r  " +
                " where not  EXISTS ( " +
                " SELECT 1 from giftresource gr where " +
                " gr.resourceId = r.seqId and gr.giftId = ?) and status =1  ";
        List<Object> param = new ArrayList<Object>();
        param.add(giftId);
        if(StringUtils.isNotEmpty(seqId)){
            sql += " and r.seqId =? ";
            param.add(seqId);
        }
        sql +=" order by r.editTime desc ";
        return findBySql(Resources.class,sql,param);
    }

    @Override
    public List<Resources> getResourceByBath(String bathIds) {
        String sql = "select * from resources r where r.seqid in ( "+bathIds+" ) and status = 1 ";
        return findBySql(Resources.class,sql, Collections.emptyList());
    }
}
