package com.xunlei.niux.data.newGift.conditions;

import com.xunlei.niux.data.newGift.conditions.exception.XLConditionException;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.script.*;
import java.util.HashMap;
import java.util.Map;

/**
 * 通用型条件类
 * Created by zy on 2016/3/29.
 */
public class ConditionCheck implements IConditions {

    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionCheck.class);
    @Override
    public boolean check(String startValue, String endValue, String gameid, String serverid, String userid,
                         String username,String toJsonObjectEL,String fields,String url,String rtnel, String... cookies) throws XLConditionException {

        Map<String,String> param = new HashMap<String, String>();
        param.put("userid",userid);
        param.put("gameid",gameid);
        param.put("serverid",serverid);

        Map<String,String> cookiesMap = new HashMap<String, String>();
        if(cookies!=null&&cookies.length>0){
            cookiesMap.put("sessionid",cookies[0]);
            cookiesMap.put("secode",cookies[1]);
            cookiesMap.put("userid",userid);
        }
        url += "?"+"callback=jQuery"+System.nanoTime();
        String content = clientUtil.getContentByPost(url, param, "utf-8", cookiesMap);
        String json = str2json(toJsonObjectEL,content);
        String fieldValue = getFieldValue(rtnel,fields, json);

        return getFlag(startValue,endValue,fieldValue);
    }


    private String str2json(String toJsonObjectEL,String content){
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        try{
            if(toJsonObjectEL.toLowerCase().indexOf("function")>-1){
                Compilable compilable = (Compilable) engine;
                Bindings bindings = engine.createBindings(); //Local级别的Binding
                CompiledScript JSFunction = compilable.compile(toJsonObjectEL); //解析编译脚本函数
                bindings.put("content", content); //通过Bindings加入参数
                return JSFunction.eval(bindings).toString();
            }else {
                engine.put("content", content);
                return engine.eval(toJsonObjectEL).toString();
            }

        }catch (Exception e){
            LOGGER.error("js expression has error !\n [error]:" + e.getMessage());
//            throw new XLConditionException("js expression has error ! " + e.getMessage());
        }
        return "";
    }

    private String getFieldValue(String rtnel,String fields , String json){
        try {
            JSONObject jsonObject = new JSONObject(json);
            if(StringUtils.isNotEmpty(rtnel)){
                String[] split = rtnel.split("=");
                if(split.length!=2){
                    LOGGER.error("rtn el has error [rtn] : "+rtnel);
//                    throw new XLConditionException("rtn el has error ");
                }
                int rtn = Integer.valueOf(jsonObject.get(split[0]).toString());
                if(rtn!=Integer.valueOf(split[1])){
                    //当rtn的值与期望值不同时设置为-100，最后返回结果为false
                    return "-100";
                }
            }
            if(StringUtils.isEmpty(fields)){
                LOGGER.error("field is need !" );
//                throw  new XLConditionException("field is need");
            }
            String [] field = fields.split("\\.");
            for(String f : field ){
                if(f==field[field.length-1]){
                    return jsonObject.get(f).toString();
                }
                jsonObject = (JSONObject) jsonObject.get(f);
            }
            LOGGER.error("no found this field ,please check ! " );
//            throw new XLConditionException("no found this field ,please check ! ");
        } catch (JSONException e) {
            LOGGER.error("field is need !" );
//            throw  new XLConditionException("field is need");
        }
        return "";
    }

    private boolean getFlag(String startValue,String endValue,String fieldValue){
        double start = Double.valueOf(startValue);
        double end = Double.valueOf(endValue);
        double value = Double.valueOf(fieldValue);

        if(end==-1){
            return value>start?true:false;
        }
        return (value>=start&&value<=end)?true:false;
    }

}
