package com.xunlei.niux.data.newGift.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.newGift.dao.GiftDao;
import com.xunlei.niux.data.newGift.vo.Gift;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zy on 2016/3/30.
 */
@Service
public class GiftBoImpl implements GiftBo {

    @Autowired
    private GiftDao giftDao;

    @Resource(name = "BaseDao")
    private BaseDao baseDao;

    @Override
    public Map<String, Object> getGiftMap(String actNo, int modelNo) {
        return giftDao.getGiftMap(actNo,modelNo);
    }

    @Override
    public Map<String, Object> takeOffGiftNm(long seqId) {
        Map<String,Object> map = new HashMap<String, Object>();
        Gift byId = giftDao.getGiftByLock(seqId);
        if(byId.getLeftNm()<1){
            map.put("rtn",-1);
            map.put("data","该礼包领取结束");
            return map;
        }

        byId.setLeftNm(byId.getLeftNm()-1);
        baseDao.updateById(byId);
        return map;
    }

    @Override
    public List<Map<String, Object>> getExtGifts(String actNo, int size) {
        return giftDao.getExtGifts(actNo,size);
    }

    @Override
    public List<Gift> getGiftsByActNo(String actNo, int size) {
      return giftDao.getGiftsByActNo(actNo,size);
    }

    @Override
    public List<Map<String, Object>> getMobileWeekGifts(String actNo, int size) {
        return giftDao.getMobileWeekGifts(actNo,size);
    }

    @Override
    public List<Map<String, Object>> getExtMapGifts(String actNo, int size) {
        return giftDao.getExtMapGifts(actNo,size);
    }

    @Override
    public List<Gift> getGiftsByLogin(Gift gift, Page page, String login) {
        return giftDao.getGiftsByLogin(gift,page,login);
    }

    @Override
    public int countGiftsByLogin(Gift gift, String login) {
        return giftDao.countGiftsByLogin(gift,login);
    }


    @Override
    public Map<String, Object> getGiftInfoMap(Long giftId) {
        return giftDao.getGiftInfoMap(giftId);
    }
}
