/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.newGift.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static HttpClient client = new DefaultHttpClient();
    private static HttpClientUtil clientUtil = new HttpClientUtil();

    private HttpClientUtil() {
    }

    public static HttpClientUtil getClientUtil() {
        return clientUtil;
    }

    public String getContentByGetUTF8(String url, Map<String, String> param) {
        return this.getContentByGet(url, param, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getContentByGet(String url, Map<String, String> param, String defaultCharset) {
        String string;
        HttpGet httpget = null;
        String result = null;
        if (param != null && !param.isEmpty()) {
            url = url.indexOf("?") > -1 ? url : url + "?";
            Set<String> keys = param.keySet();
            for (String key : keys) {
                url = url + "&" + key + "=" + param.get(key);
            }
        }
        try {
            httpget = new HttpGet(url);
            HttpResponse e = client.execute((HttpUriRequest)httpget);
            HttpEntity entity = e.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)defaultCharset);
            log.info("send URL {}\nreceive request {} ", new Object[]{url, result});
            string = result;
        }
        catch (Exception e) {
            try {
                log.error("httpGet -ERROR- url:{}", new Object[]{url, e});
            }
            catch (Throwable throwable) {
                log.info("httpget url:{},result:{}", new Object[]{url, result});
                httpget.abort();
                throw throwable;
            }
            log.info("httpget url:{},result:{}", new Object[]{url, result});
            httpget.abort();
            return null;
        }
        log.info("httpget url:{},result:{}", new Object[]{url, result});
        httpget.abort();
        return string;
    }

    public String getContentByPostUTF8(String url, Map<String, String> param, Map<String, String> cookieMap) {
        return this.getContentByPost(url, param, "utf-8", cookieMap);
    }

    public String getContentByPostUTF8(String url, Map<String, String> param) {
        return this.getContentByPost(url, param, "utf-8", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getContentByPost(String url, Map<String, String> param, String defaultCharset, Map<String, String> cookieMap) {
        String string;
        HttpPost httpPost = null;
        String result = null;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (param != null && !param.isEmpty()) {
            Set<String> keys = param.keySet();
            for (String key : keys) {
                nvps.add(new BasicNameValuePair(key, param.get(key)));
            }
        }
        try {
            BasicCookieStore store = new BasicCookieStore();
            store.addCookie((Cookie)new BasicClientCookie("sessionid", cookieMap.get("sessionid")));
            httpPost = new HttpPost(url);
            if (cookieMap != null && !cookieMap.isEmpty()) {
                Set<String> keys = cookieMap.keySet();
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    sb.append(key + "=" + cookieMap.get(key) + ";");
                }
                httpPost.setHeader("Cookie", sb.toString());
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = client.execute((HttpUriRequest)httpPost);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)defaultCharset);
            log.info("send URL {}\r\nsend param {} \r\n receive request {} ", new Object[]{url, param != null ? param.toString() : "null", result});
            string = result;
        }
        catch (Exception e) {
            try {
                log.error("httpPost -ERROR- url:{}", new Object[]{url, e});
            }
            catch (Throwable throwable) {
                log.info("httpPost url:{},result:{}", new Object[]{url, result});
                httpPost.abort();
                throw throwable;
            }
            log.info("httpPost url:{},result:{}", new Object[]{url, result});
            httpPost.abort();
            return null;
        }
        log.info("httpPost url:{},result:{}", new Object[]{url, result});
        httpPost.abort();
        return string;
    }

    public Boolean getRtn(String url, Map<String, String> param) {
        JSONObject object = this.getJsonObjectByGet(url, param);
        Object rtn = null;
        try {
            rtn = object.get("rtn");
        }
        catch (JSONException e) {
            log.error("have no field rtn");
            return false;
        }
        return rtn.equals("0");
    }

    public JSONObject getJsonObjectByGet(String url, Map<String, String> param) {
        String content = this.getContentByGetUTF8(url, param);
        try {
            JSONObject object = new JSONObject(content);
            return object;
        }
        catch (JSONException e) {
            log.error("content is not standard json: {}", new Object[]{content});
            return null;
        }
    }

    public JSONObject getJsonObjectByPost(String url, Map<String, String> param) {
        String content = this.getContentByPostUTF8(url, param);
        try {
            JSONObject object = new JSONObject(content);
            return object;
        }
        catch (JSONException e) {
            log.error("content is not standard json: {}", new Object[]{content});
            return null;
        }
    }

    public JSONObject getJsonObjectByPost(String url, Map<String, String> param, Map<String, String> cookieMap, boolean isJsonp) {
        String content = this.getContentByPostUTF8(url, param, cookieMap);
        try {
            if (isJsonp) {
                content = content.substring(content.indexOf("(") + 1);
                content = content.substring(0, content.lastIndexOf(")"));
            }
            JSONObject object = new JSONObject(content);
            return object;
        }
        catch (JSONException e) {
            log.error("content is not standard json: {}", new Object[]{content});
            return null;
        }
    }

    public JSONObject getJsonObjectByPost(String url, Map<String, String> param, Map<String, String> cookieMap) {
        return this.getJsonObjectByPost(url, param, cookieMap, false);
    }
}

