package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.newGift.vo.GiftAct;
import com.xunlei.niux.data.newGift.vo.GiftExchargeRecord;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zy on 2016/4/11.
 */
public class GiftExchargeRecordDaoImpl extends BaseDaoImpl implements GiftExchargeRecordDao {

    @Override
    public int getCountByIP(String ip, long giftId) {
        String sql ="select count(*) from giftexchargerecord where ip =? and giftId =?  and status =1 ";
        return this.getJdbcTemplate().queryForInt(sql,new Object[]{ip,giftId});
    }

    @Override
    public int getCountByUserId(String userId, long giftId) {
        String sql ="select count(*) from giftexchargerecord where userId =? and giftId =? AND status =1 ";
        return this.getJdbcTemplate().queryForInt(sql,new Object[]{userId,giftId});
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo, String startTime, String endTime, int pageSize, int pageNo) {
        return getActRecords(userId,actNo,0L,startTime,endTime,pageSize,pageNo);
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo,Long giftId,String startTime,String endTime,int pageSize,int pageNo) {
        String sql = " select SUBSTRING(recordTime,1,19) as recordTime,giftexchargerecord.* from  giftexchargerecord where userId = ? and status = 1  ";
        List<Object> param = new ArrayList<Object>();
        param.add(userId);
        if(StringUtils.isNotEmpty(actNo)){
            param.add(actNo);
            sql += " and actNo = ? ";
        }
        if(giftId>0L){
            param.add(giftId);
            sql += " and giftId  = ? ";
        }

        if(StringUtils.isNotEmpty(startTime)){
            param.add(startTime);
            sql += " and recordTime >= ?";
        }

        if(StringUtils.isNotEmpty(endTime)){
            param.add(endTime);
            sql += " and recordTime <= ?";
        }

        sql += " order by recordTime desc ";

        if(pageNo > 0&&pageSize>0){
            sql +=" limit "+(pageNo-1)*pageSize+","+pageSize;
        }else if(pageSize > 0 ){
            sql += " limit "+ pageSize;
        }

        return findBySql(GiftExchargeRecord.class,sql,param);
    }

    @Override
    public List<GiftExchargeRecord> getGiftRecordsByLogin(GiftExchargeRecord record, Page page, String login) {
        GiftAct act = new GiftAct();
        act.setActStaff(login);
        act.setStatus(1);
        Page page1 = new Page();
        page1.addOrder("isAdmin", OrderType.DESC);
        List<GiftAct> byObject = findByObject(GiftAct.class, act,page1 );
        if(byObject==null||byObject.size()==0){
            return null;
        }

        if(byObject.get(0).getIsAdmin()==1){
            return findByObject(GiftExchargeRecord.class,record,page);
        }

        String actNos = "";
        for(GiftAct act1 : byObject){
            actNos += "'"+act1.getActNo()+"',";
        }

        actNos = actNos.substring(0,actNos.length()-1);
        List<Object> list = new ArrayList<Object>();

        String sql = "select * from giftexchargerecord ger where 1=1 ";

        sql += getConditon(record,list,actNos);

        sql += " order by ger.recordTime desc ";

        if(page.getPageNo()<=0){
            page.setPageNo(1);
        }

        sql += " limit "+((page.getPageNo()-1)*page.getPageSize()) +", "+page.getPageSize();

        List<GiftExchargeRecord> giftExchargeRecords = findBySql(GiftExchargeRecord.class, sql, list);

        return giftExchargeRecords;
    }

    @Override
    public int countGiftRecordsByLogin(GiftExchargeRecord record, String login) {
        GiftAct act = new GiftAct();
        act.setStatus(1);
        act.setActStaff(login);
        Page page1 = new Page();
        page1.addOrder("isAdmin", OrderType.DESC);
        List<GiftAct> byObject = findByObject(GiftAct.class, act,page1 );
        if(byObject==null||byObject.size()==0){
            return 0;
        }

        if(byObject.get(0).getIsAdmin()==1){
            return count(record);
        }

        String actNos = "";
        for(GiftAct act1 : byObject){
            actNos += "'"+act1.getActNo()+"',";
        }
        actNos = actNos.substring(0,actNos.length()-1);
        List<Object> list =  new ArrayList<Object>();
        String sql = "select count(*) from giftexchargerecord ger where 1=1 " + getConditon(record,list,actNos);
        return getJdbcTemplate().queryForInt(sql, list.toArray());
    }

    private String getConditon(GiftExchargeRecord record,List<Object> list,String actNos){
        String sql = "";
        if(record.getSeqId()!=null&&record.getSeqId()>0){
            sql += " and ger.seqId = ? ";
            list.add(record.getSeqId());
        }

        if(record.getUserId()!=null&&record.getUserId()>0){
            sql += " and ger.userId = ? ";
            list.add(record.getUserId());
        }

        if(StringUtils.isNotEmpty(record.getActNo())){
            sql += " and ger.actNo = ? ";
            list.add(record.getActNo());
        }

        if(record.getGiftId()!=null && record.getGiftId().intValue()>0){
            sql += " and ger.giftId = ? ";
            list.add(record.getGiftId());
        }

        if(StringUtils.isNotEmpty(record.getActNm())){
            sql += " and ger.actNm = ? ";
            list.add(record.getActNm());
        }

        if(StringUtils.isNotEmpty(record.getGiftNm())){
            sql += " and ger.giftNm = ? ";
            list.add(record.getGiftNm());
        }

        if(StringUtils.isNotEmpty(record.getFromRecordTime())){
            sql +=" and ger.recordTime >= ? ";
            list.add(record.getFromRecordTime());
        }

        if(StringUtils.isNotEmpty(record.getEndRecordTime())){
            sql += " and ger.recordTime <= ? ";
            list.add(record.getEndRecordTime());
        }

        if(record.getStatus()!=null&&record.getStatus()>-1){
            sql += " and ger.status = ? ";
            list.add(record.getStatus());
        }

        if(actNos.length()>1){
            sql += " and actNo in ("+ actNos+") ";
        }
        return sql;

    }

    @Override
    public List<GiftExchargeRecord> getRecords4Move(String actNo) {
        String sql = "select ger.* from giftexchargerecord ger " +
                " left join resources r on ger.resourceId = r.seqId  " +
                " where r.resourceType='product' and ger.actNo='"+actNo+"' and  ger.status in (1,2)" +
                " order by recordTime desc ";
        List<GiftExchargeRecord> bySql = findBySql(GiftExchargeRecord.class, sql, new ArrayList<Object>());
        return bySql;
    }

    @Override
    public int getActRecordsCount(String userId, String actNo, Long giftId, String startTime, String endTime) {
        String sql = " select COUNT(*)  from  giftexchargerecord where userId = ? and status = 1  ";
        List<Object> param = new ArrayList<Object>();
        param.add(userId);
        if(StringUtils.isNotEmpty(actNo)){
            param.add(actNo);
            sql += " and actNo = ? ";
        }
        if(giftId>0L){
            param.add(giftId);
            sql += " and giftId  = ? ";
        }

        if(StringUtils.isNotEmpty(startTime)){
            param.add(startTime);
            sql += " and recordTime >= ?";
        }

        if(StringUtils.isNotEmpty(endTime)){
            param.add(endTime);
            sql += " and recordTime <= ?";
        }

        return getJdbcTemplate().queryForInt(sql, param.toArray());

    }

    @Override
    public List<GiftExchargeRecord> getGiftRecords4ActNos (GiftExchargeRecord record,  String type,String actNos , Page page,String outResourceType) {
        StringBuilder  sql =  new StringBuilder("select * from giftexchargerecord ger where 1=1   ");
        List<Object> param = new ArrayList<Object>();
        sql.append(getCondition4Type(record,param,actNos,type,outResourceType));
        sql.append("  order by ger.recordTime desc ");

        if(page!= null){
            if(page.getPageNo()<=0){
                page.setPageNo(1);
            }
            sql.append( " limit "+((page.getPageNo()-1)*page.getPageSize()) +", "+page.getPageSize());
        }

        return findBySql(GiftExchargeRecord.class,sql.toString(),param);
    }

    @Override
    public int getGiftRecordsCount4ActNos(GiftExchargeRecord record,  String type, String actNos,String outResourceType) {
        StringBuilder  sql =  new StringBuilder("select count(*) from giftexchargerecord ger  where 1 =1 ");
        List<Object> param = new ArrayList<Object>();
        sql.append(getCondition4Type(record,param,actNos,type,outResourceType));
        return this.getJdbcTemplate().queryForInt(sql.toString(),param.toArray());
    }

    private String getCondition4Type(GiftExchargeRecord record,List param,String actNos ,String type,String outResourceType){
        String result = getConditon(record,param,actNos);
        if(StringUtils.isNotEmpty(type)){
            if(type.equals("product")){
                result += " and  serialType = ? ";
                param.add(type);
            }else if(type.equals("vm")) {
                result += " and  serialType != ? ";
                param.add(type);
            }else if(type.equals("takeoff")) {
                result += " and  bonusType!=null and bonus > 0 ";
            }

        }

        if(StringUtils.isNotEmpty(outResourceType)){
            result += " and serialType not in (?) ";
            param.add(outResourceType);
        }
        return result;
    }

}
