package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.newGift.vo.GiftResource;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zy on 2016/3/24.
 */
public class GiftResourcesDaoImpl extends BaseDaoImpl implements GiftResourcesDao {

    @Override
    public void addGiftResources(long giftId,  Long[] resourcesId) {
        for(long rid : resourcesId){
            GiftResource giftResource = new GiftResource();
            giftResource.setGiftId(giftId);
            giftResource.setResourceId(rid);
            insert(giftResource);
        }
    }

    @Override
    public void removeGiftResources(long giftId, Long[] resourcesId) {
        String sql = " delete from giftresource where giftId = ? and resourceId in (" ;

        List<Object> param = new ArrayList<Object>();
        param.add(giftId);
        for(Long id : resourcesId){
            sql += "?,";
            param.add(id);
        }

        sql = sql.substring(0,sql.length()-1)+") ";
        this.execute(sql,param);
    }

    @Override
    public GiftResource getLockGiftResource(long id) {
        String sql = "select * from giftresource where seqId = ?  for update";
        List<Object> param = new ArrayList<Object>();
        param.add(id);
        List<GiftResource> bySql = this.findBySql(GiftResource.class, sql, param);
        return (bySql==null||bySql.size()==0)?null:bySql.get(0);
    }
}
