package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.newGift.vo.Gift;
import com.xunlei.niux.data.newGift.vo.GiftResource;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zy on 2016/3/30.
 */
public class GiftDaoImpl extends BaseDaoImpl implements GiftDao {

    @Override
    public Map<String, Object> getGiftMap(String actNo, int modelNo) {
        String sql ="select * from gift\n" +
                "LEFT JOIN giftextinfo on gift.seqid = giftextinfo.giftId\n" +
                "where actNo=? and modelNo=? and gift.status = ?\n" +
                "ORDER BY gift.seqId DESC ,giftextinfo.type ,giftextinfo.seqId DESC";
        final Map<String,Object> map = new HashMap<String, Object>();
        getJdbcTemplate().query(sql, new Object[]{actNo,modelNo,1}, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                if(!map.containsKey("giftId")){
                    map.put("giftId",rs.getString("seqId"));
                    map.put("giftName",rs.getString("giftname"));
                    map.put("modelNo",rs.getString("modelNo"));
                    map.put("advNo",rs.getString("advNo"));
                    map.put("startTime",rs.getString("startTime"));
                    map.put("endTime",rs.getString("endTime"));
                    map.put("total",rs.getString("total"));
                    map.put("leftNm",rs.getString("leftNm"));
                    map.put("orderNo",rs.getString("orderNo"));
                    map.put("extInfo",new ArrayList<Map<String,Object>>());
                }
                Map<String,Object> extInfoMap = new HashMap<String, Object>();
                extInfoMap.put("type",rs.getString("type"));
                extInfoMap.put("keyCode",rs.getString("keyCode"));
                extInfoMap.put("keyValue",rs.getString("keyValue"));
                ((List)map.get("extInfo")).add(extInfoMap);
            }
        });
        return map;
    }

    @Override
    public Gift getGiftByLock(long id) {
        String sql = "select * from gift where seqId = ?  for update";
        List<Object> param = new ArrayList<Object>();
        param.add(id);
        List<Gift> bySql = this.findBySql(Gift.class, sql, param);
        return (bySql==null||bySql.size()==0)?null:bySql.get(0);
    }

    @Override
    public List<Gift> getGiftsByActNo(String actNo,int size) {
        String sql = "select * from gift where actNo=? and `status`=1 and startTime<=NOW() and endTime >= NOW()" +
                " order by orderNo desc limit ? \n";
        List<Object> param = new ArrayList<Object>(2);
        param.add(actNo);
        param.add(size);
        List<Gift> gifts = findBySql(Gift.class, sql, param);


        return gifts;
    }

    public List<Map<String,Object>> getMobileWeekGifts(String actNo,int size){
        String sql = "SELECT gift.seqId, gift.giftName,gift.modelNo,gift.orderNo FROM gift  INNER JOIN \n" +
                "(SELECT  max(orderNo) as orderNo,modelNo,actNo  from gift  where actNo= ? and status =1" +
                " and startTime < NOW() and endTime > NOW() group by modelNo order by modelNo ) g \n" +
                "on gift.actNo = g.actNo and gift.modelNo = g.modelNo and gift.orderNo = g.OrderNo order by modelNo " +
                " LIMIT ? \n";
        final List<Map<String,Object>> list = new ArrayList<Map<String, Object>>();

        this.getJdbcTemplate().query(sql, new Object[]{actNo, size}, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                Map<String,Object> map = new HashMap<String, Object>();
                map.put("giftId",rs.getLong("seqId"));
                map.put("giftName",rs.getString("giftname"));
                map.put("orderNo",rs.getInt("orderNo"));
                map.put("modelNo",rs.getInt("modelNo"));
                list.add(map);
            }
        });
        return list;
    }
}
