package com.xunlei.niux.data.newGift.util;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Exclude;
import com.ferret.common.dao.util.DaoUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class UpdateNotNull {
    private String preSql = "";
    private List<Object> paramsList = new ArrayList();

    public UpdateNotNull(Object updateObj) {
        String tableName = DaoUtil.getTableName(updateObj.getClass());
        String pkColumnName = DaoUtil.getPkColumnName(updateObj.getClass());
        String updateSetContext = this.updateSetContext(updateObj);
        Field pkField = DaoUtil.getPkField(updateObj.getClass());
        Object pkValue = DaoUtil.getFiledValue(updateObj, pkField);
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(tableName).append(" set ").append(updateSetContext).append(" where ").append(pkColumnName).append("=?");
        this.preSql = sb.toString();
        this.paramsList.add(pkValue);
    }

    private String updateSetContext(Object updateObj) {
        StringBuilder sb = new StringBuilder();
        Class clazz = updateObj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        Field[] var8 = fields;
        int var7 = fields.length;

        for(int var6 = 0; var6 < var7; ++var6) {
            Field tmpStr = var8[var6];
            if(!Modifier.isPublic(tmpStr.getModifiers()) && !Modifier.isStatic(tmpStr.getModifiers()) && tmpStr.getAnnotation(Exclude.class) == null) {
                Column column = (Column)tmpStr.getAnnotation(Column.class);
                if(column == null || !column.isWhereColumn()) {
                    String columnName = DaoUtil.getColumnName(tmpStr);
                    Object value = DaoUtil.getFiledValue(updateObj, tmpStr);
                    if(value!=null){
                        sb.append(columnName).append("=?,");
                        this.paramsList.add(value);
                    }
                }
            }
        }

        String var12 = sb.toString();
        if(var12.endsWith(",")) {
            var12 = var12.substring(0, var12.length() - 1);
        }

        return var12;
    }

    public String getPreSql() {
        return this.preSql;
    }

    public List<Object> getParamsList() {
        return this.paramsList;
    }
}
