package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.newGift.vo.GiftExchargeRecord;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zy on 2016/4/11.
 */
public class GiftExchargeRecordDaoImpl extends BaseDaoImpl implements GiftExchargeRecordDao {
    @Override
    public int getCountByIP(String ip, long giftId) {
        String sql ="select count(*) from giftexchargerecord where ip =? and giftId =?  and status =1 ";
        return this.getJdbcTemplate().queryForInt(sql,new Object[]{ip,giftId});
    }

    @Override
    public int getCountByUserId(String userId, long giftId) {
        String sql ="select count(*) from giftexchargerecord where userId =? and giftId =? AND status =1 ";
        return this.getJdbcTemplate().queryForInt(sql,new Object[]{userId,giftId});
    }

    @Override
    public List<GiftExchargeRecord> getActRecords(String userId, String actNo,String startTime,String endTime) {
        String sql = " select * from  giftexchargerecord where userId = ? and status = 1  ";
        List<Object> param = new ArrayList<Object>();
        param.add(userId);
        if(StringUtils.isNotEmpty(actNo)){
            param.add(actNo);
            sql += " and actNo = ? ";
        }
        if(StringUtils.isNotEmpty(startTime)){
            param.add(startTime);
            sql += " and recordTime >= ?";
        }

        if(StringUtils.isNotEmpty(endTime)){
            param.add(endTime);
            sql += " and recordTime <= ?";
        }

        sql += " order by recordTime desc ";

        return findBySql(GiftExchargeRecord.class,sql,param);
    }
}
