package com.xunlei.niux.data.newGift.dao;

import com.xunlei.niux.data.newGift.vo.GiftExchargeRecord;

import java.util.List;

/**
 * Created by zy on 2016/4/11.
 */
public interface GiftExchargeRecordDao {

    /**
     *
     * @param ip        用户的IP地址
     * @param giftId    指定的礼包
     * @return          返回该IP地址领取该礼包的数量
     */
    int getCountByIP(String ip,long giftId);


    /**
     *
     * @param userId    用户的Id
     * @param giftId    指定的礼包Id
     * @return  返回该用户领取该礼包的数量
     */
    int getCountByUserId(String userId,long giftId);


    /**
     *
     * @param userId    用户id
     * @param actNo     活动编码
     * @return          返回该活动的领取记录
     */
    List<GiftExchargeRecord> getActRecords(String userId, String actNo,String startTime,String endTime);
}
