package com.xunlei.niux.data.newGift.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.newGift.dto.GiftConditionDTO;
import com.xunlei.niux.data.newGift.vo.Conditions;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zy on 2016/3/23.
 */
public class ConditionsDaoImpl extends BaseDaoImpl implements ConditionsDao {


    @Override
    public List<GiftConditionDTO> getConditionsByGift(String giftId, String seqId) {
        String sql = "SELECT c.seqId,c.conditionName,c.conditionUnit,gc.startValue,gc.endValue,gc.orderNo," +
                     "gc.seqId as gcId,c.rtnEL,c.compareField,c.requestURL,c.toJsonObjectEL,c.customize," +
                     "c.scriptEL,gc.remark,c.conditionClass,gc.giftId " +
                     " from conditions c\n" +
                     "INNER JOIN giftcondition gc on c.seqId = gc.conditionId\n" +
                     "where gc.giftId = ? and c.status =1  ";
        List<Object> param = new ArrayList<Object>();
        param.add(giftId);

        if(StringUtils.isNotEmpty(seqId)){
            sql += " and c.seqId =? ";
            param.add(seqId);
        }
        sql +=" order by gc.orderNo desc ";
        return findBySql(GiftConditionDTO.class,sql,param);
    }

    @Override
    public List<Conditions> getConditionsNotByGift(String giftId, String seqId) {
        String sql = "SELECT *  from conditions c " +
                " where not  EXISTS ( " +
                " SELECT 1 from giftcondition gc " +
                " where gc.conditionId = c.seqId and gc.giftId = ?) and status =1  ";
        List<Object> param = new ArrayList<Object>();
        param.add(giftId);
        if(StringUtils.isNotEmpty(seqId)){
            sql += " and c.seqId =? ";
            param.add(seqId);
        }
        sql +=" order by c.editTime desc ";
        return findBySql(Conditions.class,sql,param);
    }
}
