/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.lychat.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.lychat.bo.LyChatBo;
import com.xunlei.niux.data.lychat.constants.LyChatConstant;
import com.xunlei.niux.data.lychat.dto.LyChatOperationLogDTO;
import com.xunlei.niux.data.lychat.dto.LyChatWarningDTO;
import com.xunlei.niux.data.lychat.utils.DateUtil;
import com.xunlei.niux.data.lychat.vo.LyChatDetailVO;
import com.xunlei.niux.data.lychat.vo.LyChatWarningVO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LyChatBoImpl
implements LyChatBo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void lockLyChatWarning(Long seqId) {
        LyChatWarningVO lcw = (LyChatWarningVO)this.baseDao.findById(LyChatWarningVO.class, (Number)seqId);
        lcw.setStatus(LyChatConstant.STATUS_DONE);
        lcw.setFinishTime(DateUtil.formatNowByDefault());
        this.baseDao.updateById((Object)lcw);
        LyChatDetailVO cd = (LyChatDetailVO)this.baseDao.findById(LyChatDetailVO.class, (Number)lcw.getDetailId());
        if (StringUtils.isEmpty((String)cd.getCustomerId()) && StringUtils.isEmpty((String)cd.getRoleId()) && StringUtils.isEmpty((String)cd.getRoleName())) {
            return;
        }
        String sql = "update lychat_warning w set w.status=0, w.finishTime=now()  where exists (select * from lychat_detail d where d.seqId=w.detailId and d.gameId=? and d.serverId= ? and (d.customerId=? or d.roleId=? or d.rolename=?) and  d.isWarning=1 and w.status=1)";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(cd.getGameId());
        params.add(cd.getServerId());
        params.add(cd.getCustomerId());
        params.add(cd.getRoleId());
        params.add(cd.getRoleName());
        this.baseDao.execute(sql, params);
    }

    @Override
    public void ignoreLyChatWarning(Long seqId) {
        LyChatWarningVO cw = (LyChatWarningVO)this.baseDao.findById(LyChatWarningVO.class, (Number)seqId);
        cw.setStatus(LyChatConstant.STATUS_IGNORE);
        cw.setFinishTime(DateUtil.formatNowByDefault());
        this.baseDao.updateById((Object)cw);
    }

    @Override
    public void ignoreAllLyChatWarning() {
        this.baseDao.execute("update lychat_warning set status=2, finishtime=now() where status=1", new ArrayList());
    }

    @Override
    public List<LyChatWarningDTO> findChatWarning(int pageNo, int pageSize) {
        String sql = "select d.*, w.happenTime,w.finishTime, w.seqId as warnSeqId, w.status, w.warnType from lychat_warning w left join lychat_detail d on  w.detailId=d.seqId order by happenTime desc limit ?,? ";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(pageNo);
        params.add(pageSize);
        return this.baseDao.findBySql(LyChatWarningDTO.class, sql, params);
    }

    @Override
    public List<LyChatWarningDTO> findChatWarningByStatus(Integer status, int pageNo, int pageSize) {
        String sql = "select d.*, w.happenTime,w.finishTime, w.seqId as warnSeqId, w.status, w.warnType  from lychat_warning w left join lychat_detail d on  w.detailId=d.seqId where w.status=? order by happenTime desc limit ?,? ";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(status);
        params.add(pageNo);
        params.add(pageSize);
        return this.baseDao.findBySql(LyChatWarningDTO.class, sql, params);
    }

    @Override
    public List<LyChatOperationLogDTO> findLyChatOperationLog(int pageNo, int pageSize) {
        String sql = "select a.* from lychat_operation_log a left join lychat_detail d on a.detailId=d.seqId order by a.workTime desc limit ?,? ";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(pageNo);
        params.add(pageSize);
        return this.baseDao.findBySql(LyChatOperationLogDTO.class, sql, params);
    }
}

