package com.xunlei.niux.data.lychat.utils;


import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static ThreadLocal timeThreadLocal = new ThreadLocal() {
        protected Object initialValue() {
            return null;
        }
    };
    private static ThreadLocal dateThreadLocal = new ThreadLocal() {
        protected Object initialValue() {
            return null;
        }
    };

    public DateUtil() {
    }

    public static DateFormat getTimeFormat() {
        Object df = (DateFormat)timeThreadLocal.get();
        if(df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            timeThreadLocal.set(df);
        }

        return (DateFormat)df;
    }

    public static DateFormat getDateFormat() {
        Object df = (DateFormat)dateThreadLocal.get();
        if(df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            dateThreadLocal.set(df);
        }

        return (DateFormat)df;
    }

    public static String getOrderTime() {
        return getTimeFormat().format(new Date());
    }

    public static Date yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static String formatNow(String pattern) {
        return format(new Date(), pattern);
    }

    public static String formatNowByDefault() {
        return formatNow("yyyy-MM-dd HH:mm:ss");
    }

    public static Date nextYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 1);
        return calendar.getTime();
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static long compareTime(String fromtime, String totime) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date one = null;
        Date two = null;
        long days = 0L;

        try {
            one = df.parse(fromtime);
            two = df.parse(totime);
            long e = one.getTime();
            long time2 = two.getTime();
            long diff = e - time2;
            days = diff / 86400000L;
        } catch (ParseException var13) {
            var13.printStackTrace();
        }

        return days;
    }
}