package com.xunlei.niux.data.lychat.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.lychat.dto.LyChatOperationLogDTO;
import com.xunlei.niux.data.lychat.dto.LyChatWarningDTO;
import com.xunlei.niux.data.lychat.constants.LyChatConstant;
import com.xunlei.niux.data.lychat.utils.DateUtil;
import com.xunlei.niux.data.lychat.vo.LyChatDetailVO;
import com.xunlei.niux.data.lychat.vo.LyChatWarningVO;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class LyChatBoImpl implements LyChatBo{

    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }



    @Override
    public void lockLyChatWarning(Long seqId){

        LyChatWarningVO lcw = baseDao.findById(LyChatWarningVO.class, seqId);
        lcw.setStatus(LyChatConstant.STATUS_DONE);
        lcw.setFinishTime(DateUtil.formatNowByDefault());
        baseDao.updateById(lcw);

        LyChatDetailVO cd = findWarningByDetailId(lcw.getDetailId());

        if(StringUtils.isEmpty(cd.getCustomerId()) && StringUtils.isEmpty(cd.getRoleId()) && StringUtils.isEmpty(cd.getRoleName())){
            return;
        }

        String sql = "update lychat_warning w set w.status=0, w.finishTime=now()  " +
                "where exists (select * from lychat_detail d where d.detailId=w.detailId and d.gameId=? and d.serverId= ? and (d.customerId=? or d.roleId=? or d.rolename=?) and  d.isWarning=1)";
        List<Object> params = new ArrayList<Object>();
        params.add(cd.getGameId());
        params.add(cd.getServerId());
        params.add(cd.getCustomerId());
        params.add(cd.getRoleId());
        params.add(cd.getRoleName());
        baseDao.execute(sql, params);
    }


    @Override
    public void ignoreLyChatWarning(Long seqId) {
        LyChatWarningVO cw = baseDao.findById(LyChatWarningVO.class,seqId);
        cw.setStatus(LyChatConstant.STATUS_IGNORE);
        cw.setFinishTime(DateUtil.formatNowByDefault());
        baseDao.updateById(cw);
    }

    @Override
    public List<LyChatWarningDTO> findChatWarning(int pageNo, int pageSize) {
        String sql = "select d.*, w.happenTime,w.finishTime, w.seqId as warnSeqId, w.status, w.warnType from lychat_warning w left join lychat_detail d on  w.detailId=d.detailId order by happenTime desc limit ?,? ";
        List<Object> params = new ArrayList<Object>();
        params.add(pageNo);
        params.add(pageSize);
        return baseDao.findBySql(LyChatWarningDTO.class,sql, params);
    }

    @Override
    public List<LyChatWarningDTO> findChatWarningByStatus(Integer status, int pageNo, int pageSize) {
        String sql = "select d.*, w.happenTime,w.finishTime, w.seqId as warnSeqId, w.status, w.warnType  from lychat_warning w left join lychat_detail d on  w.detailId=d.detailId where w.status=? order by happenTime desc limit ?,? ";
        List<Object> params = new ArrayList<Object>();
        params.add(status);
        params.add(pageNo);
        params.add(pageSize);
        return baseDao.findBySql(LyChatWarningDTO.class,sql, params);
    }

    @Override
    public List<LyChatOperationLogDTO> findLyChatOperationLog( int pageNo, int pageSize) {
        String sql = "select a.* from lychat_operation_log a left join lychat_detail d on a.detailId=d.detailId order by a.workTime desc limit ?,? ";
        List<Object> params = new ArrayList<Object>();
        params.add(pageNo);
        params.add(pageSize);
        return baseDao.findBySql(LyChatOperationLogDTO.class,sql, params);
    }

    @Override
    public List<LyChatDetailVO> findByDetailId(Long detailId) {
        return baseDao.findBySql(LyChatDetailVO.class,"select * from lychat_detail where detailId="+detailId);
    }

    @Override
    public LyChatDetailVO findWarningByDetailId(Long detailId) {
        return baseDao.findBySql(LyChatDetailVO.class,"select * from lychat_detail where detailId="+detailId+" and isWarning=1").get(0);
    }

}
