package com.xunlei.niux.data.lychat.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;


public class FacadeFactory {
	public static final IFacade INSTANCE;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/lychat/xml/tomcatjndi.xml","com/xunlei/niux/data/lychat/xml/applicationContext.xml"}).getBean("Facade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/lychat/xml/jdbc.xml","com/xunlei/niux/data/lychat/xml/applicationContext.xml"}).getBean("Facade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/lychat/xml/springjndi.xml","com/xunlei/niux/data/lychat/xml/applicationContext.xml"}).getBean("Facade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_lychat_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
