/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.gamepay.util;

import java.util.ResourceBundle;
import javax.mail.internet.MimeMessage;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailUtil {
    private static JavaMailSender sender;
    private static String from;

    private static void init() {
        if (sender == null) {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("applicationContext-mail.xml");
            sender = (JavaMailSender)ctx.getBean("mailSender");
            from = ResourceBundle.getBundle("gamepay").getString("fromemail");
            if (from != null) {
                from = from.trim();
            }
        }
    }

    public static void sendMail(String title, String html, String ... receivers) throws Exception {
        JavaMailSenderImpl senderImpl = new JavaMailSenderImpl();
        MimeMessage mailMessage = senderImpl.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage, true, "utf-8");
        messageHelper.setTo(receivers);
        messageHelper.setFrom(from);
        messageHelper.setSubject(title);
        messageHelper.setText(html, true);
        sender.send(mailMessage);
    }

    public static void main(String[] args) {
        try {
            MailUtil.sendMail("test", "test", "lisu@xunlei.com");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        MailUtil.init();
    }
}

