/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.gamepay.util;

import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.util.DataSourceUtil;
import com.xunlei.gamepay.util.ShardingUtil;
import com.xunlei.gamepay.vo.DbConfig;
import com.xunlei.gamepay.vo.DsConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

public class DbConfigUtil {
    private static Map<String, DataSource> DbConfigMap = null;
    private static IFacade facade = IFacade.INSTANCE;
    private static Logger log = Logger.getLogger(DbConfigUtil.class);
    private static Map<String, DataSource> PayDbConfiMap = null;

    public static DataSource getPayDbSource(String dsname) {
        if (PayDbConfiMap == null) {
            PayDbConfiMap = new HashMap<String, DataSource>();
            for (String key : DataSourceUtil.DATASOURCEMAP.keySet()) {
                DsConfig dsconfig = DataSourceUtil.DATASOURCEMAP.get(key);
                String paydbname = DataSourceUtil.PAYDBNAMEMAP.get(key);
                String dburl = dsconfig.getDburl().replace("****", paydbname);
                DataSource dataSource = DbConfigUtil.createDataSource(dburl, dsconfig.getDbusr(), dsconfig.getDbpwd());
                PayDbConfiMap.put(key, dataSource);
            }
        }
        return PayDbConfiMap.get(dsname);
    }

    public static DataSource getDataSource(String gameid) {
        DataSource dataSource;
        log.debug((Object)("getDataSource:" + gameid));
        if (DbConfigMap == null) {
            DbConfigUtil.initDataSource();
        }
        if ((dataSource = DbConfigMap.get(gameid)) == null) {
            DbConfig query = new DbConfig();
            query.setGameid(gameid);
            DbConfig data = facade.findDbConfig(query);
            dataSource = DbConfigUtil.createDataSource(data);
            DbConfigMap.put(gameid, dataSource);
        }
        return dataSource;
    }

    public static DataSource getDataSourceSharding() {
        log.debug((Object)"Sharding getDataSource:");
        if (DbConfigMap == null) {
            DbConfigUtil.initDataSource();
        }
        DbConfig data = new DbConfig();
        data.setDbname(ShardingUtil.DATABASE);
        data.setDsname(ShardingUtil.DSNAME);
        data.setGameid(ShardingUtil.GAMEID);
        DataSource dataSource = DbConfigMap.get(data.getGameid());
        if (dataSource == null) {
            dataSource = DbConfigUtil.createDataSource(data);
            DbConfigMap.put(data.getGameid(), dataSource);
        }
        return dataSource;
    }

    private static void initDataSource() {
        DbConfigMap = new HashMap<String, DataSource>();
        DbConfig query = new DbConfig();
        List<DbConfig> list = facade.queryDbConfigForList(query);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DbConfig data = list.get(i);
                if (data == null) continue;
                DataSource dataSource = DbConfigUtil.createDataSource(data);
                DbConfigMap.put(data.getGameid(), dataSource);
            }
        }
    }

    private static DataSource createDataSource(DbConfig data) {
        DataSource dataSource = null;
        try {
            DsConfig dsconfig = DataSourceUtil.DATASOURCEMAP.get(data.getDsname());
            String dburl = dsconfig.getDburl().replace("****", data.getDbname());
            dataSource = DbConfigUtil.createDataSource(dburl, dsconfig.getDbusr(), dsconfig.getDbpwd());
        }
        catch (Exception e) {
            log.error((Object)("Exception:" + e.getMessage()));
        }
        return dataSource;
    }

    private static DataSource createDataSource(String url, String user, String password) {
        BasicDataSource source = new BasicDataSource();
        source.setDriverClassName("com.mysql.jdbc.Driver");
        source.setUrl(url);
        source.setUsername(user);
        source.setPassword(password);
        return source;
    }
}

