package com.xunlei.gamepay.dao;


import javax.sql.DataSource;

import org.apache.log4j.Logger;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.util.DbConfigUtil;
import com.xunlei.gamepay.vo.PayDetail;

public class PayDetailDaoImpl extends JdbcBaseDao implements IPaydetailDao {

	private static Logger log = Logger.getLogger(PayDetailDaoImpl.class);
	@Override
	public Sheet<PayDetail> query(PayDetail data,PagedFliper fliper) {

		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		String sql = "select * from paydetail ";
		String rowsql = "select count(1) from paydetail";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid='").append(data.getGameid()).append("'");
		}
		
		if(isNotEmpty(data.getChargetype())){
			wheresql.append(" And ChargeType='").append(data.getChargetype()).append("'");
		}
		
		if(isNotEmpty(data.getBankno())){
			wheresql.append(" And BankNo='").append(data.getBankno()).append("'");
		}
		
		if(isNotEmpty(data.getFromusername())){
			wheresql.append(" And FromUserName='").append(data.getFromusername()).append("'");
		}
		
		if(isNotEmpty(data.getFrominneruserid())){
			wheresql.append(" And FromInnerUserid='").append(data.getFrominneruserid()).append("'");
		}
		
		if(isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName='").append(data.getTousername()).append("'");
		}
		
		if(isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid='").append(data.getToinneruserid()).append("'");
		}
		
		if(isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid='").append(data.getServerid()).append("'");
		}
		
		if(isNotEmpty(data.getServername())){
			wheresql.append(" And ServerName='").append(data.getServername()).append("'");
		}
		
		if(isNotEmpty(data.getRoleid())){
			wheresql.append(" And RoleId='").append(data.getRoleid()).append("'");
		}
		
		if(isNotEmpty(data.getRolename())){
			wheresql.append(" And RoleName='").append(data.getRolename()).append("'");
		}
		
		if(isNotEmpty(data.getOrderid())){
			wheresql.append(" And OrderId='").append(data.getOrderid()).append("'");
		}
		
//		if(isNotEmpty(data.getReferfrom())){
//			wheresql.append(" And Referfrom='").append(data.getReferfrom()).append("'");
//		}
		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And OrderTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And OrderTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		
		rowsql += wheresql.toString();
		log.info("rowsql:"+rowsql);
		int rowcount = this.getSingleInt(rowsql);
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		
		sql += wheresql.toString();
		
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<PayDetail>(rowcount,query(PayDetail.class,sql));
	}

}
