package com.xunlei.gamepay.dao;

import java.util.List;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.vo.DbConfig;

public class DbConfigDaoImpl extends JdbcBaseDao implements IDbConfigDao {

	@Override
	public void save(DbConfig data) {
		this.saveObject(data);
	}

	@Override
	public void delete(DbConfig data) {
		this.deleteObject(data);
	}

	@Override
	public void deleteByIds(long... ids) {
		this.deleteObject("dbconfig", ids);
	}

	@Override
	public DbConfig find(DbConfig data) {
		return this.findObjectByCondition(data);
	}

	@Override
	public Sheet<DbConfig> query(DbConfig data, PagedFliper fliper) {
		String sql = "select * from dbconfig ";
		String sqlcount = "select count(1) from dbconfig ";
		StringBuffer wheresql = new StringBuffer(" where 1=1 ");
		if(isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid='").append(data.getGameid()).append("'");
		}
		if(isNotEmpty(data.getDsname())){
			wheresql.append(" And dsname='").append(data.getDsname()).append("'");
		}
		if(isNotEmpty(data.getDbname())){
			wheresql.append(" And dbname='").append(data.getDbname()).append("'");
		}
		if(isNotEmpty(data.getGamename())){
			wheresql.append(" And gamename='").append(data.getGamename()).append("'");
		}
		if(isNotEmpty(data.getIsNewDb())){
			wheresql.append(" And IsNewDb='").append(data.getIsNewDb()).append("'");
		}
		
		sqlcount += wheresql.toString();
		int rowcount = this.getSingleInt(sqlcount);
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		sql += wheresql.toString();
		
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<DbConfig>(rowcount, query(DbConfig.class, sql, new String[0]));
	}
	public List<DbConfig> queryForList(DbConfig data){
		String sql = "select * from dbconfig ";
		StringBuffer wheresql = new StringBuffer(" where 1=1 ");
		if(isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid='").append(data.getGameid()).append("'");
		}
		if(isNotEmpty(data.getDsname())){
			wheresql.append(" And dsname='").append(data.getDsname()).append("'");
		}
		if(isNotEmpty(data.getDbname())){
			wheresql.append(" And dbname='").append(data.getDbname()).append("'");
		}
		if(isNotEmpty(data.getGamename())){
			wheresql.append(" And gamename='").append(data.getGamename()).append("'");
		}
		if(isNotEmpty(data.getIsNewDb())){
			wheresql.append(" And IsNewDb='").append(data.getIsNewDb()).append("'");
		}
		sql += wheresql.toString();
		return query(DbConfig.class, sql, new String[0]);
	}
	@Override
	public void update(DbConfig data) {
		this.updateObject(data);
	}
	
}
