package com.xunlei.gamepay.bo;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.vo.GuildPayDetailOKDTO;
import com.xunlei.gamepay.vo.PayDetailOK;

import java.util.List;
import java.util.Map;

public interface IPayDetailOKBo {

	public Sheet<PayDetailOK> queryPayDetailOK(PayDetailOK data, PagedFliper fliper);
	
	public PayDetailOK queryPayDetailOKSum(PayDetailOK data);
	
	public void updatePayDetailOK(PayDetailOK data);
	
	public void insertPayDetailOK(PayDetailOK data);
	
	public PayDetailOK findPayDetailOK(PayDetailOK data);
	
	public PayDetailOK findMaxPayDetailOK(PayDetailOK data);
	
//	public PayDetailOK doMoveRepairToPayDetailOK(PayDetailOK data);

	/**
	 *
	 * @param gameId			指定游戏id(5位)
	 * @param startTime			开始时间
	 * @param endTime			结束时间
	 * @param topNo				top数据量
	 * @return					返回排行榜，结构如下：
	 * 							Map[userId->用户id，userName->用户账号，payMondeySum->用户支付总金额]
	 * 							PS:如果条件中有任何一个为null或topNo=0,则直接返回 [空列表]
	 */
	List<Map> getTopRankByGameId(String gameId , String startTime, String endTime, int topNo);

	/**
	 * 查询公会用户订单
	 * @param data
	 * @param channelIdgameIds
	 * @param gameservers gameId和serverId对应关系
	 * @param groupNo 
	 * @param fliper
	 * @return
	 */
	public Sheet<GuildPayDetailOKDTO> queryPayDetailOK(PayDetailOK data, String[] channelIdgameIds, Map<String, List<String>> gameservers, String groupNo, PagedFliper fliper);
	
	/**
	 * 查询工会订单 
	 * @param data
	 * @param channelIdgameIds
	 * @param gameservers gameId和serverId对应关系
	 * @param groupNo 
	 * @return
	 */
	public GuildPayDetailOKDTO queryPayDetailOKSum(PayDetailOK data, String[] channelIdgameIds, Map<String, List<String>> gameservers, String groupNo);
}
