package com.xunlei.gamepay.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;

import javax.sql.DataSource;

import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowCallbackHandler;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.util.DbConfigUtil;
import com.xunlei.gamepay.util.ShardingUtil;
import com.xunlei.gamepay.vo.ThundercurrencyoutdetailOK;

public class ThundercurrencyoutdetailOKDaoImpl extends JdbcBaseDao implements IThundercurrencyoutdetailOKDao{

	private static Logger log = Logger.getLogger(ThundercurrencyoutdetailOKDaoImpl.class);
	@Override
	public Sheet<ThundercurrencyoutdetailOK> query(
			ThundercurrencyoutdetailOK data, PagedFliper fliper) {

    	try{//根据配置文件来决定分库还是不分
    		String mode = ResourceBundle.getBundle("gamepay").getString("dbReadMode");

    		//只能读一个库
    		//分库时
    		if("2".equals(mode)){
    			return querySharding(data, fliper);
    		}
    		
    	}catch(Exception e){logger.error("[Sharding Exception]", e);}//不分库时
    	
		DataSource dataSource = DbConfigUtil.getDataSource(data.getGameid());
		if(dataSource == null){
			log.error("Gameid:"+data.getGameid()+",该游戏未配置数据源");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		String sql = "select * from thundercurrencyoutdetail ";
		String rowsql = "select count(1) from thundercurrencyoutdetail";
		
		String sqlhis = " select * from thundercurrencyoutdetailhistory ";
		String rowsqlhis = " select count(1) from thundercurrencyoutdetailhistory ";
		StringBuffer wheresql = new StringBuffer(" where 1=1 ");
		StringBuffer wheresqlhis =  new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getAssociateUserId())){
			wheresql.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
			wheresqlhis.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
		}
		
		if(isNotEmpty(data.getUserId())){
			wheresql.append(" And UserId='").append(data.getUserId()).append("'");
			wheresqlhis.append(" And UserId='").append(data.getUserId()).append("'");
		}
		
		if(isNotEmpty(data.getServerId())){
			wheresql.append(" And ServerId='").append(data.getServerId()).append("'");
			wheresqlhis.append(" And ServerId='").append(data.getServerId()).append("'");
		}
		
		if(isNotEmpty(data.getServerName())){
			wheresql.append(" And ServerName='").append(data.getServerName()).append("'");
			wheresqlhis.append(" And ServerName='").append(data.getServerName()).append("'");
		}
		
		if(isNotEmpty(data.getOrderId())){
			wheresql.append(" And OrderId='").append(data.getOrderId()).append("'");
			wheresqlhis.append(" And OrderId='").append(data.getOrderId()).append("'");
		}
		
		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		
		if(isNotEmpty(data.getFromOrderTimeHis())){
			wheresqlhis.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTimeHis()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTimeHis())){
			wheresqlhis.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTimeHis()).append(" 23:59:59'");
		}
		//是否过滤掉测试账号
		if("1".equals(data.getFilertestaccount())){ //查询非测试账号
			wheresqlhis.append(" And AssociateUserId not in (select userid from testaccount) ");
			wheresql.append(" And AssociateUserId not in (select userid from testaccount) ");
		}
		else if("2".equals(data.getFilertestaccount())){//只查询测试账号
			wheresqlhis.append(" And AssociateUserId in (select userid from testaccount) ");
			wheresql.append(" And AssociateUserId in (select userid from testaccount) ");
		}
		
		
		if(data.getQuerytype() == 0){
			rowsql = rowsql + wheresql.toString();
			sql = sql + wheresql.toString();
		}else if(data.getQuerytype() == 1){
			rowsql = "select ("+rowsql+ wheresql.toString() +")+("+ rowsqlhis + wheresqlhis.toString()+") as rowcount" ;
			sql = sql + wheresql.toString() + " union "+sqlhis + wheresqlhis.toString();
		}
		else if(data.getQuerytype() == 2){
			rowsql = rowsqlhis + wheresqlhis.toString();
			sql = sqlhis + wheresqlhis.toString();
		}
		else {
			return Sheet.EMPTY;
		}
		log.info("rowsql:"+rowsql);
		int rowcount = this.getSingleInt(rowsql);
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		log.info("sql:"+sql);
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<ThundercurrencyoutdetailOK>(rowcount, query(ThundercurrencyoutdetailOK.class,sql,new String[0]));
	}
	@Override
	public ThundercurrencyoutdetailOK querySum(ThundercurrencyoutdetailOK data) {

    	try{//根据配置文件来决定分库还是不分
    		String mode = ResourceBundle.getBundle("gamepay").getString("dbReadMode");

    		//只能读一个库
    		//分库时
    		if("2".equals(mode)){
    			return querySumSharding(data);
    		}
    		
    	}catch(Exception e){logger.error("[Sharding Exception]", e);}//不分库时
    	
		DataSource dataSource = DbConfigUtil.getDataSource(data.getGameid());
		if(dataSource == null){
			log.error("Gameid:"+data.getGameid()+",该游戏未配置数据源");
			return null;
		}
		this.setDataSource(dataSource);
		final ThundercurrencyoutdetailOK result = new ThundercurrencyoutdetailOK();
		
		String sql = "select * from thundercurrencyoutdetail";
		String sqlhis = " select * from thundercurrencyoutdetailhistory ";
		
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		StringBuffer wheresqlhis =  new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getAssociateUserId())){
			wheresql.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
			wheresqlhis.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
		}
		
		if(isNotEmpty(data.getUserId())){
			wheresql.append(" And UserId='").append(data.getUserId()).append("'");
			wheresqlhis.append(" And UserId='").append(data.getUserId()).append("'");
		}
		
		if(isNotEmpty(data.getServerId())){
			wheresql.append(" And ServerId='").append(data.getServerId()).append("'");
			wheresqlhis.append(" And ServerId='").append(data.getServerId()).append("'");
		}
		
		if(isNotEmpty(data.getServerName())){
			wheresql.append(" And ServerName='").append(data.getServerName()).append("'");
			wheresqlhis.append(" And ServerName='").append(data.getServerName()).append("'");
		}
		
		if(isNotEmpty(data.getOrderId())){
			wheresql.append(" And OrderId='").append(data.getOrderId()).append("'");
			wheresqlhis.append(" And OrderId='").append(data.getOrderId()).append("'");
		}
		
		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		
		if(isNotEmpty(data.getFromOrderTimeHis())){
			wheresqlhis.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTimeHis()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTimeHis())){
			wheresqlhis.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTimeHis()).append(" 23:59:59'");
		}
		
		//是否过滤掉测试账号
		if("1".equals(data.getFilertestaccount())){ //查询非测试账号
			wheresqlhis.append(" And AssociateUserId not in (select userid from testaccount) ");
			wheresql.append(" And AssociateUserId not in (select userid from testaccount) ");
		}
		else if("2".equals(data.getFilertestaccount())){//只查询测试账号
			wheresqlhis.append(" And AssociateUserId in (select userid from testaccount) ");
			wheresql.append(" And AssociateUserId in (select userid from testaccount) ");
		}
		
		if(data.getQuerytype() == 0){
			sql = "select sum(a.ArriveMoney) as ArriveMoney from ("+sql+ wheresql.toString()+") a";
		}else if(data.getQuerytype() == 1){
			sql = "select sum(a.ArriveMoney) as ArriveMoney from ("+sql+ wheresql.toString() +" union "+sqlhis + wheresqlhis.toString() +") a";
		}
		else if(data.getQuerytype() == 2){
			sql = "select sum(a.ArriveMoney) as ArriveMoney from ("+sqlhis + wheresqlhis.toString() +") a";
		}
		else {
			return null;
		}
		log.info("sql:"+sql);
		this.getJdbcTemplate().query(sql, new RowCallbackHandler() {
			public void processRow(ResultSet resultSet) throws SQLException {
				result.setArriveMoney(resultSet.getDouble("ArriveMoney"));
			}
		});
		return result;
	}

	public Sheet<ThundercurrencyoutdetailOK> querySharding(
			ThundercurrencyoutdetailOK data, PagedFliper fliper) {
		DataSource dataSource = DbConfigUtil.getDataSourceSharding();
		if(dataSource == null){
			log.error("querySharding Gameid:"+data.getGameid()+",该游戏未配置数据源");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		String sql = "select * from  "+ShardingUtil.getTableNameSharding("thundercurrencyoutdetail", data.getGameid());
		String rowsql = "select count(1) from "+ShardingUtil.getTableNameSharding("thundercurrencyoutdetail", data.getGameid());
		
		String sqlhis = " select * from  "+ShardingUtil.getTableNameSharding("thundercurrencyoutdetailhistory", data.getGameid());
		String rowsqlhis = " select count(1) from  "+ShardingUtil.getTableNameSharding("thundercurrencyoutdetailhistory", data.getGameid());
		StringBuffer wheresql = new StringBuffer(" where 1=1 ");
		StringBuffer wheresqlhis =  new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getAssociateUserId())){
			wheresql.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
			wheresqlhis.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
		}
		
		if(isNotEmpty(data.getUserId())){
			wheresql.append(" And UserId='").append(data.getUserId()).append("'");
			wheresqlhis.append(" And UserId='").append(data.getUserId()).append("'");
		}
		
		if(isNotEmpty(data.getServerId())){
			wheresql.append(" And ServerId='").append(data.getServerId()).append("'");
			wheresqlhis.append(" And ServerId='").append(data.getServerId()).append("'");
		}
		
		if(isNotEmpty(data.getServerName())){
			wheresql.append(" And ServerName='").append(data.getServerName()).append("'");
			wheresqlhis.append(" And ServerName='").append(data.getServerName()).append("'");
		}
		
		if(isNotEmpty(data.getOrderId())){
			wheresql.append(" And OrderId='").append(data.getOrderId()).append("'");
			wheresqlhis.append(" And OrderId='").append(data.getOrderId()).append("'");
		}
		
		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		
		if(isNotEmpty(data.getFromOrderTimeHis())){
			wheresqlhis.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTimeHis()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTimeHis())){
			wheresqlhis.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTimeHis()).append(" 23:59:59'");
		}
		//是否过滤掉测试账号
		if("1".equals(data.getFilertestaccount())){ //查询非测试账号
			wheresqlhis.append(" And AssociateUserId not in (select userid from "+ShardingUtil.getTableNameSharding("testaccount", data.getGameid())+") ");
			wheresql.append(" And AssociateUserId not in (select userid from "+ShardingUtil.getTableNameSharding("testaccount", data.getGameid())+") ");
		}
		else if("2".equals(data.getFilertestaccount())){//只查询测试账号
			wheresqlhis.append(" And AssociateUserId in (select userid from "+ShardingUtil.getTableNameSharding("testaccount", data.getGameid())+") ");
			wheresql.append(" And AssociateUserId in (select userid from "+ShardingUtil.getTableNameSharding("testaccount", data.getGameid())+") ");
		}
		
		
		if(data.getQuerytype() == 0){
			rowsql = rowsql + wheresql.toString();
			sql = sql + wheresql.toString();
		}else if(data.getQuerytype() == 1){
			rowsql = "select ("+rowsql+ wheresql.toString() +")+("+ rowsqlhis + wheresqlhis.toString()+") as rowcount" ;
			sql = sql + wheresql.toString() + " union "+sqlhis + wheresqlhis.toString();
		}
		else if(data.getQuerytype() == 2){
			rowsql = rowsqlhis + wheresqlhis.toString();
			sql = sqlhis + wheresqlhis.toString();
		}
		else {
			return Sheet.EMPTY;
		}
		log.info("rowsql:"+rowsql);
		int rowcount = this.getSingleInt(rowsql);
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		log.info("sql:"+sql);
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<ThundercurrencyoutdetailOK>(rowcount, query(ThundercurrencyoutdetailOK.class,sql,new String[0]));
	}
	
	public ThundercurrencyoutdetailOK querySumSharding(ThundercurrencyoutdetailOK data) {
		DataSource dataSource = DbConfigUtil.getDataSourceSharding();
		if(dataSource == null){
			log.error("querySumSharding Gameid:"+data.getGameid()+",该游戏未配置数据源");
			return null;
		}
		this.setDataSource(dataSource);
		final ThundercurrencyoutdetailOK result = new ThundercurrencyoutdetailOK();
		
		String sql = "select * from "+ShardingUtil.getTableNameSharding("thundercurrencyoutdetail", data.getGameid());
		String sqlhis = " select * from "+ShardingUtil.getTableNameSharding("thundercurrencyoutdetailhistory", data.getGameid());
		
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		StringBuffer wheresqlhis =  new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getAssociateUserId())){
			wheresql.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
			wheresqlhis.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
		}
		
		if(isNotEmpty(data.getUserId())){
			wheresql.append(" And UserId='").append(data.getUserId()).append("'");
			wheresqlhis.append(" And UserId='").append(data.getUserId()).append("'");
		}
		
		if(isNotEmpty(data.getServerId())){
			wheresql.append(" And ServerId='").append(data.getServerId()).append("'");
			wheresqlhis.append(" And ServerId='").append(data.getServerId()).append("'");
		}
		
		if(isNotEmpty(data.getServerName())){
			wheresql.append(" And ServerName='").append(data.getServerName()).append("'");
			wheresqlhis.append(" And ServerName='").append(data.getServerName()).append("'");
		}
		
		if(isNotEmpty(data.getOrderId())){
			wheresql.append(" And OrderId='").append(data.getOrderId()).append("'");
			wheresqlhis.append(" And OrderId='").append(data.getOrderId()).append("'");
		}
		
		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		
		if(isNotEmpty(data.getFromOrderTimeHis())){
			wheresqlhis.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTimeHis()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTimeHis())){
			wheresqlhis.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTimeHis()).append(" 23:59:59'");
		}
		
		//是否过滤掉测试账号
		if("1".equals(data.getFilertestaccount())){ //查询非测试账号
			wheresqlhis.append(" And AssociateUserId not in (select userid from "+ShardingUtil.getTableNameSharding("testaccount", data.getGameid())+") ");
			wheresql.append(" And AssociateUserId not in (select userid from "+ShardingUtil.getTableNameSharding("testaccount", data.getGameid())+") ");
		}
		else if("2".equals(data.getFilertestaccount())){//只查询测试账号
			wheresqlhis.append(" And AssociateUserId in (select userid from "+ShardingUtil.getTableNameSharding("testaccount", data.getGameid())+") ");
			wheresql.append(" And AssociateUserId in (select userid from "+ShardingUtil.getTableNameSharding("testaccount", data.getGameid())+") ");
		}
		
		if(data.getQuerytype() == 0){
			sql = "select sum(a.ArriveMoney) as ArriveMoney from ("+sql+ wheresql.toString()+") a";
		}else if(data.getQuerytype() == 1){
			sql = "select sum(a.ArriveMoney) as ArriveMoney from ("+sql+ wheresql.toString() +" union "+sqlhis + wheresqlhis.toString() +") a";
		}
		else if(data.getQuerytype() == 2){
			sql = "select sum(a.ArriveMoney) as ArriveMoney from ("+sqlhis + wheresqlhis.toString() +") a";
		}
		else {
			return null;
		}
		log.info("sql:"+sql);
		this.getJdbcTemplate().query(sql, new RowCallbackHandler() {
			public void processRow(ResultSet resultSet) throws SQLException {
				result.setArriveMoney(resultSet.getDouble("ArriveMoney"));
			}
		});
		return result;
	}
	
}
