package com.xunlei.gamepay.dao;

import javax.sql.DataSource;
import org.apache.log4j.Logger;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.util.DbConfigUtil;
import com.xunlei.gamepay.vo.RechargeErrorOrder;

public class RechargeErrorOrderDaoImpl extends JdbcBaseDao implements IRechargeErrorOrderDao {
	private static Logger log = Logger.getLogger(RechargeErrorOrderDaoImpl.class);

	@Override
	public Sheet<RechargeErrorOrder> query(RechargeErrorOrder data,
			PagedFliper fliper) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		String sql = "select * from RechargeErrorOrder ";
		String rowsql = "select count(1) from RechargeErrorOrder ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getOrderId())){
			wheresql.append(" And OrderId='").append(data.getOrderId()).append("'");
		}
		if(isNotEmpty(data.getGameId())){
			wheresql.append(" And gameid='").append(data.getGameId()).append("'");
		}
		if(isNotEmpty(data.getUserid())){
			wheresql.append(" And userid='").append(data.getUserid()).append("'");
		}
		rowsql = rowsql + wheresql.toString();
		log.info("rowsql:"+rowsql);
		int rowcount = this.getSingleInt(rowsql);
		if(rowcount<=0){
			return Sheet.EMPTY;
		}		
		sql += wheresql.toString();
		
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}else{
				sql = sql + " order by FailTime desc " ;
			}
			sql = sql + fliper.limitsql(rowcount);
		}else{
			sql = sql + " order by FailTime desc " ;
		}
		return new Sheet<RechargeErrorOrder>(rowcount,query(RechargeErrorOrder.class,sql));
	}
	
	
}
