package com.xunlei.gamepay.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.util.DbConfigUtil;
import com.xunlei.gamepay.vo.ChargeMonthEnd;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowCallbackHandler;

import javax.sql.DataSource;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ChargeMonthEndDaoImpl extends JdbcBaseDao implements
		IChargeMonthEndDao {
	private static Logger log = Logger.getLogger(ChargeDayEndDaoImpl.class);
	@Override
	public ChargeMonthEnd querForSum(ChargeMonthEnd data) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
		}
		this.setDataSource(dataSource);
		
		
		final ChargeMonthEnd result = new ChargeMonthEnd();
		String sql = "select sum(testamt) as testamt," +
				"sum(testordernums) as testordernums," +
				"sum(incomeamt) as incomeamt," +
				"sum(incomeordernums) as incomeordernums ," +
				"sum(allamt) as allamt," +
				"sum(giftamt) as giftamt,sum(vouchersMoney) as svouchersMoney,sum(notSuccessMoney) as notSuccessMoney  from chargemonthend ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		if (isNotEmpty(data.getGameid())) {
			wheresql.append(" And gameid='").append(data.getGameid()).append(
					"'");
		}
        if (isNotEmpty(data.getGameIdLike())) {
            if(data.getGameIdLike().equals("5%")){
                wheresql.append(" And (gameid like '5%' or gameid in ('00140','00146','00148','00149','00150'))");
            }else if(data.getGameIdLike().equals("0%")){
                wheresql.append(" And gameid like '0%' And gameid not in ('00140','00146','00148','00149','00150')");
            }else if(data.getGameIdLike().equals("6%")){
            	wheresql.append(" And gameid like '6%'");
            }
        }
		if (isNotEmpty(data.getFrommonth())) {
			wheresql.append(" And balancemonth>='").append(data.getFrommonth()).append("'");
		}
		if (isNotEmpty(data.getTomonth())) {
			wheresql.append(" And balancemonth<='").append(data.getTomonth()).append("'");
		}

		getJdbcTemplate().query(sql + wheresql.toString(),
				new RowCallbackHandler() {
					public void processRow(ResultSet resultSet)
							throws SQLException {
						result.setTestamt(resultSet.getDouble("testamt"));
						result.setTestordernums(resultSet.getInt("testordernums"));
						result.setIncomeamt(resultSet.getDouble("incomeamt"));
						result.setIncomeordernums(resultSet.getInt("incomeordernums"));
						result.setAllamt(resultSet.getDouble("allamt"));
						result.setGiftamt(resultSet.getDouble("giftamt"));
						result.setVouchersMoney(resultSet.getDouble("svouchersMoney"));
						result.setNotSuccessMoney(resultSet.getDouble("notSuccessMoney"));
					}
				});
		return result;
	}

	@Override
	public Sheet<ChargeMonthEnd> query(ChargeMonthEnd data, PagedFliper fliper) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		
		String sql = "select * from chargemonthend ";
		String rowsql = "select count(1) from chargemonthend";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		if (isNotEmpty(data.getGameid())) {
			wheresql.append(" And gameid='").append(data.getGameid()).append(
					"'");
		}
        if (isNotEmpty(data.getGameIdLike())) {
            if(data.getGameIdLike().equals("5%")){
                wheresql.append(" And (gameid like '5%' or gameid in ('00140','00146','00148','00149','00150'))");
            }else if(data.getGameIdLike().equals("0%")){
                wheresql.append(" And gameid like '0%' And gameid not in ('00140','00146','00148','00149','00150')");
            }else if(data.getGameIdLike().equals("6%")){
            	wheresql.append(" And gameid like '6%'");
            }
        }
		if (isNotEmpty(data.getFrommonth())) {
			wheresql.append(" And balancemonth>='").append(data.getFrommonth()).append("'");
		}
		if (isNotEmpty(data.getTomonth())) {
			wheresql.append(" And balancemonth<='").append(data.getTomonth()).append("'");
		}

		rowsql += wheresql.toString();
		int rows = this.getSingleInt(rowsql);
		if (rows <= 0) {
			return Sheet.EMPTY;
		}
		sql += wheresql.toString();
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rows);
		}
		return new Sheet<ChargeMonthEnd>(rows, query(ChargeMonthEnd.class, sql));
	}

}
