package com.xunlei.common.dao;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.Extendable;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;

public class BaseDao extends JdbcBaseDao {
	private HibernateTemplate hibernateTemplate;

	public <T> T findObject(Class<T> clazz, long seqid) {
		try {
			return (T) getHibernateTemplate().load(clazz, Long.valueOf(seqid));
		} catch (Exception e) {
		}
		return null;
	}

	public void insertObject(Object data) {
		getHibernateTemplate().save(data);
	}

	public void deleteObject(Object data) {
		getHibernateTemplate().delete(data);
	}

	public void updateObject(Object data) {
		getHibernateTemplate().update(data);
	}

	public final void setSessionFactory(SessionFactory sessionFactory) {
		logger.debug("在" + getClass().getName() + "中，sessionFactory被注入");
		this.hibernateTemplate = createHibernateTemplate(sessionFactory);
	}

	protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
		return new HibernateTemplate(sessionFactory);
	}

	public final SessionFactory getSessionFactory() {
		return this.hibernateTemplate != null ? this.hibernateTemplate.getSessionFactory() : null;
	}

	public final void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}

	public final HibernateTemplate getHibernateTemplate() {
		return this.hibernateTemplate;
	}

	protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
		return getSession(this.hibernateTemplate.isAllowCreate());
	}

	protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException,
			IllegalStateException {
		return !allowCreate ? SessionFactoryUtils.getSession(getSessionFactory(), false)
				: SessionFactoryUtils.getSession(getSessionFactory(),
						this.hibernateTemplate.getEntityInterceptor(),
						this.hibernateTemplate.getJdbcExceptionTranslator());
	}

	public <T> T saveObject(T object) {
		Class<?> clazz = object.getClass();
		String className = clazz.toString().substring(clazz.toString().lastIndexOf('.') + 1).toLowerCase();

		StringBuilder sqlColumn = new StringBuilder("(");
		StringBuilder sqlValue = new StringBuilder("(");

		String fname = "";
		Method method = null;
		Object fieldValue = null;
		Class<?> type = null;
		try {
			Field[] fields = clazz.getDeclaredFields();

			for (int i = 0; i < fields.length; i++) {
				Field field = fields[i];
				fname = field.getName();
				if (field.getAnnotation(Extendable.class) != null) {
					logger.debug(fname + "标记为@Extendable，不保存此字段");
				} else if (fname.equalsIgnoreCase("seqid")) {
					logger.debug(fname + "为自增主键，不用插入");
				} else {
					method = clazz.getDeclaredMethod("get" + capitalize(fname), new Class[0]);
					fieldValue = method.invoke(object, new Object[0]);
					sqlColumn.append(fname);
					type = field.getType();
					if (isNumType(type)) {
						String str=fieldValue==null?null:fieldValue.toString();
						sqlValue.append(str);
					} else if (field.getType() == Date.class) {
						sqlValue.append("'").append(DatetimeUtil.formatyyyyMMddHHmmss((Date) fieldValue))
								.append("'");
					} else {
						sqlValue.append("'").append(StringTools.escapeSql(fieldValue)).append("'");
					}

					sqlColumn.append(",");
					sqlValue.append(",");
				}

			}
			String sqlInsert = "insert into " + className + sqlColumn.substring(0, sqlColumn.length() - 1)
					+ ") values" + sqlValue.substring(0, sqlValue.length() - 1) + ")";
			execute(sqlInsert);
			return null;
		} catch (Exception ex) {
			logger.error(ex.getMessage());
			throw new XLRuntimeException(ex);
		}
	}
	private static String capitalize(String name) {
		return name.substring(0, 1).toUpperCase() + name.substring(1);
	}
}
