package com.xunlei.gamepay.dao;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.vo.PayDetailOK;

import java.util.List;
import java.util.Map;

public interface IPayDetailOKDao {

	public Sheet<PayDetailOK> query(PayDetailOK data, PagedFliper fliper);
	
	public PayDetailOK querySum(PayDetailOK data);
	
	public void update(PayDetailOK data);
	
	public void insert(PayDetailOK data);
	
	public PayDetailOK find(PayDetailOK data);
	
	public PayDetailOK findMaxPayDetailOK(PayDetailOK data);

	/**
	 *
	 * @param gameId			指定游戏id(5位)
	 * @param startTime			开始时间
	 * @param endTime			结束时间
	 * @param topNo				top数据量
	 * @return					返回排行榜，结构如下：
	 * 							Map[userId->用户id，userName->用户账号，payMondeySum->用户支付总金额]
	 * 							PS:如果条件中有任何一个为null或topNo=0,则直接返回 [空列表]
	 */
	List<Map> getTopRankByGameId(String gameId ,String startTime,String endTime, int topNo);
}
