package com.xunlei.gamepay.dao;

import java.util.ResourceBundle;

import javax.sql.DataSource;

import org.apache.log4j.Logger;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.util.DbConfigUtil;
import com.xunlei.gamepay.util.ShardingUtil;
import com.xunlei.gamepay.vo.ThundercurrencyoutdetailReq;

public class ThundercurrencyoutdetailReqDaoImpl extends JdbcBaseDao implements
		IThundercurrencyoutdetailReqDao {

	private static Logger log = Logger.getLogger(ThundercurrencyoutdetailReqDaoImpl.class);
	@Override
	public Sheet<ThundercurrencyoutdetailReq> query(
			ThundercurrencyoutdetailReq data, PagedFliper fliper) {

    	try{//根据配置文件来决定分库还是不分
    		String mode = ResourceBundle.getBundle("gamepay").getString("dbReadMode");

    		//只能读一个库
    		//分库时
    		if("2".equals(mode)){
    			return querySharding(data, fliper);
    		}
    		
    	}catch(Exception e){logger.error("[Sharding Exception]", e);}//不分库时
    	
		DataSource dataSource = DbConfigUtil.getDataSource(data.getGameid());
		if(dataSource == null){
			log.error("Gameid:"+data.getGameid()+",该游戏未配置数据源");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		String sql = "select * from failthundercurrencyoutdetail";
		String rowsql = "select count(1) from failthundercurrencyoutdetail";
		
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getAssociateUserId())){
			wheresql.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
		}
		
		if(isNotEmpty(data.getUserId())){
			wheresql.append(" And UserId='").append(data.getUserId()).append("'");
		}
		
		if(isNotEmpty(data.getServerId())){
			wheresql.append(" And ServerId='").append(data.getServerId()).append("'");
		}
		
		if(isNotEmpty(data.getServerName())){
			wheresql.append(" And ServerName='").append(data.getServerName()).append("'");
		}
		
		if(isNotEmpty(data.getOrderId())){
			wheresql.append(" And OrderId='").append(data.getOrderId()).append("'");
		}
		
		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		
		rowsql += wheresql.toString();
		int rowcount =this.getSingleInt(rowsql);
		log.info("rowsql:"+rowsql);
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		sql += wheresql.toString();
		log.info("sql:"+sql);
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<ThundercurrencyoutdetailReq>(rowcount, query(ThundercurrencyoutdetailReq.class,sql,new String[0]));
	}
	
	
	public Sheet<ThundercurrencyoutdetailReq> querySharding(
			ThundercurrencyoutdetailReq data, PagedFliper fliper) {
		DataSource dataSource = DbConfigUtil.getDataSourceSharding();
		if(dataSource == null){
			log.error("getDataSourceSharding Gameid:"+data.getGameid()+",该游戏未配置数据源");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		String sql = "select * from "+ShardingUtil.getTableNameSharding("failthundercurrencyoutdetail", data.getGameid());
		String rowsql = "select count(1) from "+ShardingUtil.getTableNameSharding("failthundercurrencyoutdetail", data.getGameid());
		
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getAssociateUserId())){
			wheresql.append(" And AssociateUserId='").append(data.getAssociateUserId()).append("'");
		}
		
		if(isNotEmpty(data.getUserId())){
			wheresql.append(" And UserId='").append(data.getUserId()).append("'");
		}
		
		if(isNotEmpty(data.getServerId())){
			wheresql.append(" And ServerId='").append(data.getServerId()).append("'");
		}
		
		if(isNotEmpty(data.getServerName())){
			wheresql.append(" And ServerName='").append(data.getServerName()).append("'");
		}
		
		if(isNotEmpty(data.getOrderId())){
			wheresql.append(" And OrderId='").append(data.getOrderId()).append("'");
		}
		
		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ThunderCurrencyOutTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		
		rowsql += wheresql.toString();
		int rowcount =this.getSingleInt(rowsql);
		log.info("rowsql:"+rowsql);
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		sql += wheresql.toString();
		log.info("sql:"+sql);
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<ThundercurrencyoutdetailReq>(rowcount, query(ThundercurrencyoutdetailReq.class,sql,new String[0]));
	}

}
