package com.xunlei.gamepay.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.gamepay.vo.GiftVipCard;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-10-25
 * Time: 下午12:03
 * To change this template use File | Settings | File Templates.
 */
public class GiftVipCardDaoImpl extends BaseDaoImpl implements IGiftVipCardDao {
    private static Logger log = Logger.getLogger(GiftVipCardDaoImpl.class);

    @Override
    public GiftVipCard queryForSum(GiftVipCard data) {

        StringBuilder stringBuilder = new StringBuilder();
        List<String> argsList = new ArrayList<String>();
        stringBuilder.append("SELECT SUM(payMondey) as payMondeySum,SUM(GiftMonth) as giftMonthSum FROM gamepay.GiftVipCard WHERE 1=1 ");
        if(StringUtils.isNotEmpty(data.getGameId())){
            stringBuilder.append("and gameId = ? ");
            argsList.add(data.getGameId());
        }
        if(StringUtils.isNotEmpty(data.getUserId())){
            stringBuilder.append("and userId = ? ");
            argsList.add(data.getUserId());
        }
        if(StringUtils.isNotEmpty(data.getServerId())){
            stringBuilder.append("and serverId = ? ");
            argsList.add(data.getServerId());
        }
        if(StringUtils.isNotEmpty(data.getGiftStatus())){
            stringBuilder.append("and giftStatus = ? ");
            argsList.add(data.getGiftStatus());
        }
        if(StringUtils.isNotEmpty(data.getFromStarttime())){
            stringBuilder.append("and GiftTime >= ? ");
            argsList.add(data.getFromStarttime());
        }
        if(StringUtils.isNotEmpty(data.getToEndtime())){
            stringBuilder.append("and GiftTime <= ? ");
            argsList.add(data.getToEndtime());
        }
        Object[] args = argsList.toArray();

        final GiftVipCard giftVipCard = new GiftVipCard();
        getJdbcTemplate().query(stringBuilder.toString(), args, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                giftVipCard.setPayMondey(resultSet.getDouble("payMondeySum"));
                giftVipCard.setGiftMonth(resultSet.getString("giftMonthSum"));
            }
        });

        return giftVipCard;
    }
}
