package com.xunlei.gamepay.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.gamepay.util.DbConfigUtil;

import javax.sql.DataSource;

/**
 * Created by HGH on 2017/2/22.
 */
public class GameDbDaoImpl extends JdbcBaseDao implements IGameDbDao {

    private DataSource getDataSourceByGameId(String gameId) {
        DataSource dataSource = DbConfigUtil.getDataSource(gameId);
        this.setDataSource(dataSource);
        return dataSource;
    }

    @Override
    public int queryForInt(String gameId, String sql, Object[] args) {
        DataSource dataSource = getDataSourceByGameId(gameId);
        return this.getJdbcTemplate().queryForInt(sql, args);
    }
}
