package com.xunlei.gamepay.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.log4j.Logger;

import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.DbConfig;
import com.xunlei.gamepay.vo.DsConfig;

public class DbConfigUtil {

	private static Map<String,DataSource> DbConfigMap = null;
	private static IFacade facade = IFacade.INSTANCE;
	
	private static Logger log = Logger.getLogger(DbConfigUtil.class);
	private static Map<String,DataSource> PayDbConfiMap = null;

	public static DataSource getPayDbSource(String dsname){
		if(PayDbConfiMap == null){
			PayDbConfiMap = new HashMap<String,DataSource>();
			for(String key:DataSourceUtil.DATASOURCEMAP.keySet()){
				DsConfig dsconfig = DataSourceUtil.DATASOURCEMAP.get(key);
				String paydbname = DataSourceUtil.PAYDBNAMEMAP.get(key);
				String dburl = dsconfig.getDburl().replace("****", paydbname);
				DataSource dataSource = createDataSource(dburl,dsconfig.getDbusr(),dsconfig.getDbpwd());
				PayDbConfiMap.put(key, dataSource);
			}
		}
		return PayDbConfiMap.get(dsname);
	}
	
	public static DataSource getDataSource(String gameid) {
		log.debug("getDataSource:"+gameid);
		if(DbConfigMap == null){
			initDataSource();
		}
		
		DataSource dataSource = DbConfigMap.get(gameid);
		if(dataSource == null){
			DbConfig query = new DbConfig();
			query.setGameid(gameid);
			DbConfig data = facade.findDbConfig(query);
			dataSource = createDataSource(data);
			DbConfigMap.put(gameid, dataSource);
		}
		return dataSource;
	}
	
	/**
	 * 分表数据源创建
	 * @return
	 */
	public static DataSource getDataSourceSharding() {

		log.debug("Sharding getDataSource:");
		if(DbConfigMap == null){
			initDataSource();
		}

		DbConfig data = new DbConfig();
		data.setDbname(ShardingUtil.DATABASE);
		data.setDsname(ShardingUtil.DSNAME);
		data.setGameid(ShardingUtil.GAMEID);
		
		DataSource dataSource = DbConfigMap.get(data.getGameid());
		if(dataSource == null){
			dataSource = createDataSource(data);
			DbConfigMap.put(data.getGameid(), dataSource);
		}
		return dataSource;
	}
	
	//初始化数据源
	private static void initDataSource(){
		DbConfigMap = new HashMap<String,DataSource>();
		DbConfig query = new DbConfig();
		List<DbConfig> list = facade.queryDbConfigForList(query);
		if(list!=null && list.size()>0){
			for(int i=0;i<list.size();i++){
				DbConfig data = list.get(i);
				if(data == null)
					continue;
				DataSource dataSource = createDataSource(data);
				DbConfigMap.put(data.getGameid(), dataSource);
			}
		}
	}
	
	private static DataSource createDataSource(DbConfig data){
		DataSource dataSource = null;
		try{
			DsConfig dsconfig = DataSourceUtil.DATASOURCEMAP.get(data.getDsname());
			String dburl = dsconfig.getDburl().replace("****", data.getDbname());
			dataSource = createDataSource(dburl,dsconfig.getDbusr(),dsconfig.getDbpwd());
		}catch(Exception e){
			log.error("Exception:"+e.getMessage());
		}
		return dataSource;
	}
	
	private static DataSource createDataSource(String url, String user,
			String password) {
		org.apache.commons.dbcp.BasicDataSource source = new org.apache.commons.dbcp.BasicDataSource();
		source.setDriverClassName("com.mysql.jdbc.Driver");
		source.setUrl(url);
		source.setUsername(user);
		source.setPassword(password);
		return source;
	}
}
