package com.xunlei.gamepay.dao;

import javax.sql.DataSource;

import com.xunlei.gamepay.vo.PayDetailOK;
import com.xunlei.gamepay.vo.PayDetailOKEachGamePaySumDTO;
import org.apache.log4j.Logger;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.util.DbConfigUtil;
import com.xunlei.gamepay.vo.PaydetailokSum;

import java.util.ArrayList;
import java.util.List;

public class PaydetailokSumDaoImpl extends JdbcBaseDao implements
		IPaydetailokSumDao {
	private static Logger log = Logger.getLogger(PaydetailokSumDaoImpl.class);

	@Override
	public Sheet<PaydetailokSum> query(PaydetailokSum data, PagedFliper fliper) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		
		String sql = "select * from paydetailok ";
		String rowsql = "select count(1) from paydetailok ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid='").append(data.getGameid()).append("'");
		}
		
		if(isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName='").append(data.getTousername()).append("'");
		}
		
		if(isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid='").append(data.getToinneruserid()).append("'");
		}
		
		if(isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid='").append(data.getServerid()).append("'");
		}
		
		
		if(isNotEmpty(data.getFromtime())){
			wheresql.append(" And ChargeSuccessTime>='").append(data.getFromtime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getTotime())){
			wheresql.append(" And ChargeSuccessTime<='").append(data.getTotime()).append(" 23:59:59'");
		}

		StringBuffer sumwhere = new StringBuffer(" Having 1=1 ");
		if(isNotEmpty(data.getFrommoney())){
			sumwhere.append(" And SumMoney>=").append(data.getFrommoney());
		}
		if(isNotEmpty(data.getTomoney())){
			sumwhere.append(" And SumMoney<=").append(data.getTomoney());
		}
		
		StringBuffer sumsql = new StringBuffer();
		sumsql.append("select GameId,ToUserName,ToInnerUserid,Serverid,sum(TotalMoney) as SumMoney,count(1) as Chargenum,sum(TotalMoney)/count(1) as AvgMoney from  (");
		sumsql.append(sql);
		sumsql.append(wheresql.toString());
		sumsql.append(") a group by ToUserName,Serverid ");
		
		sumsql.append(sumwhere.toString());
		
		StringBuffer sumsqlcount = new StringBuffer();
		sumsqlcount.append("select count(1) from  (");
		sumsqlcount.append(sumsql.toString());
		sumsqlcount.append(") b ");

		log.info("rowsql:"+sumsqlcount.toString());
		int rowcount = this.getSingleInt(sumsqlcount.toString());
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sumsql.append(" order by ").append(fliper.getSortColumn());
			}
			sumsql.append(fliper.limitsql(rowcount));
		}
		log.info("sql:"+sumsql.toString());
		return new Sheet<PaydetailokSum>(rowcount,query(PaydetailokSum.class,sumsql.toString()));
	}

	public Sheet<PaydetailokSum> exportQuery(PaydetailokSum data, PagedFliper fliper) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		
		String sql = "select * from paydetailok ";
		String rowsql = "select count(1) from paydetailok ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid='").append(data.getGameid()).append("'");
		}
		
		if(isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName='").append(data.getTousername()).append("'");
		}
		
		if(isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid='").append(data.getToinneruserid()).append("'");
		}
		
		if(isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid='").append(data.getServerid()).append("'");
		}
		
		
		if(isNotEmpty(data.getFromtime())){
			wheresql.append(" And ChargeSuccessTime>='").append(data.getFromtime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getTotime())){
			wheresql.append(" And ChargeSuccessTime<='").append(data.getTotime()).append(" 23:59:59'");
		}

		StringBuffer sumwhere = new StringBuffer(" Having 1=1 ");
		if(isNotEmpty(data.getFrommoney())){
			sumwhere.append(" And SumMoney>=").append(data.getFrommoney());
		}
		if(isNotEmpty(data.getTomoney())){
			sumwhere.append(" And SumMoney<=").append(data.getTomoney());
		}
		
		StringBuffer sumsql = new StringBuffer();
		sumsql.append("select GameId,ToUserName,ToInnerUserid,Serverid,sum(TotalMoney) as SumMoney,count(1) as Chargenum,sum(TotalMoney)/count(1) as AvgMoney from  (");
		sumsql.append(sql);
		sumsql.append(wheresql.toString());
		sumsql.append(") a group by ToUserName,Serverid ");
		
		sumsql.append(sumwhere.toString());
		
		StringBuffer sumsqlcount = new StringBuffer();
		sumsqlcount.append("select count(1) from  (");
		sumsqlcount.append(sumsql.toString());
		sumsqlcount.append(") b ");

		log.info("rowsql:"+sumsqlcount.toString());
		int rowcount = this.getSingleInt(sumsqlcount.toString());
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sumsql.append(" order by ").append(fliper.getSortColumn());
			}
			//sumsql.append(fliper.limitsql(rowcount));
		}
		log.info("sql:"+sumsql.toString());
		return new Sheet<PaydetailokSum>(rowcount,query(PaydetailokSum.class,sumsql.toString()));
	}

    @Override
    public List<PayDetailOKEachGamePaySumDTO> getEachGamePaySum(PayDetailOK data) {
        List<PayDetailOKEachGamePaySumDTO> list = new ArrayList<PayDetailOKEachGamePaySumDTO>();
        DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
        if(dataSource==null){
            log.info("dsname:"+data.getDsname()+",no this datasource.");
            return list;
        }
        this.setDataSource(dataSource);

        String sql="select gameId,sum(payMondey) as payMoney from paydetailok where ChargeSuccessTime>='"+data.getFromSuccessTme()+"' and ChargeSuccessTime<='"+data.getToSuccessTime()+"' group by GameId";
        return this.query(PayDetailOKEachGamePaySumDTO.class, sql);
    }
}
