package com.xunlei.gamepay.dao;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import com.xunlei.common.dao.JdbcBaseDao2;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.util.DbConfigUtil;
import com.xunlei.gamepay.vo.PayDetailOK;

public class PayDetailOKDaoImpl extends JdbcBaseDao2 implements IPayDetailOKDao {
	
	private static Logger log = Logger.getLogger(PayDetailOKDaoImpl.class);
	@Override
	public Sheet<PayDetailOK> query(PayDetailOK data, PagedFliper fliper) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);
		String sql = "select * from paydetailok ";
		String rowsql = "select count(1) from paydetailok ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid='").append(data.getGameid()).append("'");
		}
		if(isNotEmpty(data.getChargetype())){
			wheresql.append(" And ChargeType='").append(data.getChargetype()).append("'");
		}
		
		if(isNotEmpty(data.getBankno())){
			wheresql.append(" And BankNo='").append(data.getBankno()).append("'");
		}
		
		if(isNotEmpty(data.getFromusername())){
			wheresql.append(" And FromUserName='").append(data.getFromusername()).append("'");
		}
		
		if(isNotEmpty(data.getFrominneruserid())){
			wheresql.append(" And FromInnerUserid='").append(data.getFrominneruserid()).append("'");
		}
		
		if(isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName='").append(data.getTousername()).append("'");
		}
		
		if(isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid='").append(data.getToinneruserid()).append("'");
		}
		
		if(isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid='").append(data.getServerid()).append("'");
		}
		
		if(isNotEmpty(data.getServername())){
			wheresql.append(" And ServerName='").append(data.getServername()).append("'");
		}
		
		if(isNotEmpty(data.getRoleid())){
			wheresql.append(" And RoleId='").append(data.getRoleid()).append("'");
		}
		
		if(isNotEmpty(data.getRolename())){
			wheresql.append(" And RoleName='").append(data.getRolename()).append("'");
		}
		
		if(isNotEmpty(data.getOrderid())){
			wheresql.append(" And OrderId='").append(data.getOrderid()).append("'");
		}
		
		if(isNotEmpty(data.getOrderidstatus())){
			wheresql.append(" And OrderIdStatus='").append(data.getOrderidstatus()).append("'");
		}

		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ChargeSuccessTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ChargeSuccessTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		if(isNotEmpty(data.getFromSuccessTme())){
			wheresql.append(" And SuccessTime>='").append(data.getFromSuccessTme()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToSuccessTime())){
			wheresql.append(" And successTime<='").append(data.getToSuccessTime()).append(" 23:59:59'");
		}
		if(isNotEmpty(data.getReferfrom())){
			wheresql.append(" And Referfrom='").append(data.getReferfrom()).append("'");
		}
		if(isNotEmpty(data.getNiuxactno())){
			wheresql.append(" And Niuxactno='").append(data.getNiuxactno()).append("'");
		}
		if("1".equals(data.getExcepttest())){
			wheresql.append(" And ToUserName<>'youxiceshi' And ToUserName<> 'fontong'  and  ToUserName<> 'niuxfontong'");
		}else if("2".equals(data.getExcepttest())){
			wheresql.append(" And (ToUserName='youxiceshi' Or ToUserName = 'fontong' or ToUserName='niuxfontong') ");
		}
		if(isNotEmpty(data.getGiftFlag())){
			wheresql.append(" And GiftFlag='").append(data.getGiftFlag()).append("'");
		}
		
		rowsql = rowsql + wheresql.toString();
		log.info("rowsql:"+rowsql);
		int rowcount = this.getSingleInt(rowsql);
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		
		
		sql += wheresql.toString();
		
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<PayDetailOK>(rowcount,query(PayDetailOK.class,sql));
	}

	@Override
	public PayDetailOK querySum(PayDetailOK data) {
		final PayDetailOK result = new PayDetailOK();
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return null;
		}
		String sql = "select sum(TotalMoney) as price,sum(payMondey) as payprice,sum(vouchersMoney) as voucherprice from paydetailok ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid='").append(data.getGameid()).append("'");
		}
		if(isNotEmpty(data.getChargetype())){
			wheresql.append(" And ChargeType='").append(data.getChargetype()).append("'");
		}
		
		if(isNotEmpty(data.getBankno())){
			wheresql.append(" And BankNo='").append(data.getBankno()).append("'");
		}
		
		if(isNotEmpty(data.getFromusername())){
			wheresql.append(" And FromUserName='").append(data.getFromusername()).append("'");
		}
		
		if(isNotEmpty(data.getFrominneruserid())){
			wheresql.append(" And FromInnerUserid='").append(data.getFrominneruserid()).append("'");
		}
		
		if(isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName='").append(data.getTousername()).append("'");
		}
		
		if(isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid='").append(data.getToinneruserid()).append("'");
		}
		
		if(isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid='").append(data.getServerid()).append("'");
		}
		
		if(isNotEmpty(data.getServername())){
			wheresql.append(" And ServerName='").append(data.getServername()).append("'");
		}
		
		if(isNotEmpty(data.getRoleid())){
			wheresql.append(" And RoleId='").append(data.getRoleid()).append("'");
		}
		
		if(isNotEmpty(data.getRolename())){
			wheresql.append(" And RoleName='").append(data.getRolename()).append("'");
		}
		
		if(isNotEmpty(data.getOrderid())){
			wheresql.append(" And OrderId='").append(data.getOrderid()).append("'");
		}
		
		if(isNotEmpty(data.getOrderidstatus())){
			wheresql.append(" And OrderIdStatus='").append(data.getOrderidstatus()).append("'");
		}
		
		if(isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ChargeSuccessTime>='").append(data.getFromOrderTime()).append(" 00:00:00'");
		}
		
		if(isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ChargeSuccessTime<='").append(data.getToOrderTime()).append(" 23:59:59'");
		}
		if(isNotEmpty(data.getFromSuccessTme())){
			wheresql.append(" And successTime>='").append(data.getFromSuccessTme()).append(" 00:00:00'");
		}		
		if(isNotEmpty(data.getToSuccessTime())){
			wheresql.append(" And successTime<='").append(data.getToSuccessTime()).append(" 23:59:59'");
		}
		if(isNotEmpty(data.getReferfrom())){
			wheresql.append(" And Referfrom='").append(data.getReferfrom()).append("'");
		}
		if(isNotEmpty(data.getNiuxactno())){
			wheresql.append(" And Niuxactno='").append(data.getNiuxactno()).append("'");
		}
		if("1".equals(data.getExcepttest())){
			wheresql.append(" And ToUserName<>'youxiceshi' And ToUserName<> 'fontong'  and  ToUserName<> 'niuxfontong'");
		}else if("2".equals(data.getExcepttest())){
			wheresql.append(" And (ToUserName='youxiceshi' Or ToUserName = 'fontong'  or ToUserName='niuxfontong') ");
		}
		
		if(isNotEmpty(data.getGiftFlag())){
			wheresql.append(" And GiftFlag='").append(data.getGiftFlag()).append("'");
		}
		
		
		log.info("sql:"+sql + wheresql.toString());
		//double money = this.getSingleDouble(sql + wheresql.toString());
		Map resultMap = this.getJdbcTemplate().queryForMap(sql + wheresql.toString());
		if(resultMap != null){
			String price = resultMap.get("price")==null?"0.0":resultMap.get("price").toString();
			String payprice = resultMap.get("payprice")==null?"0.0":resultMap.get("payprice").toString();
			String voucherprice = resultMap.get("voucherprice")==null?"0.0":resultMap.get("voucherprice").toString();
			result.setTotalmoney(price);
			result.setPayMondey(new Double(payprice==null?"0":payprice));
			result.setVouchersMoney(new Double(voucherprice==null?"0":voucherprice));
			//result.setPayMondey(new Double(price)-result.getVouchersMoney());
		}else{
			result.setPayMondey(new Double("0.0"));
			result.setVouchersMoney(new Double("0.0"));
			result.setPayMondey(new Double("0.0"));
		}
		return result;
	}

	@Override
	public void update(PayDetailOK data) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return;
		}
		this.setDataSource(dataSource);
		this.updateObject(data);
	}

	@Override
	public void insert(PayDetailOK data) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return;
		}
		this.setDataSource(dataSource);
		this.saveObject(data);
	}
	
	@Override
	public PayDetailOK find(PayDetailOK data){
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if(dataSource==null){
			log.info("dsname:"+data.getDsname()+",no this datasource.");
			return null;
		}
		this.setDataSource(dataSource);
		return this.findObjectByCondition(data);
	}
}
