package com.xunlei.gamepay.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowCallbackHandler;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.util.DbConfigUtil;
import com.xunlei.gamepay.vo.ChargeDayend;

public class ChargeDayEndDaoImpl extends JdbcBaseDao implements
		IChargeDayEndDao {
	private static Logger log = Logger.getLogger(ChargeDayEndDaoImpl.class);

	@Override
	public Sheet<ChargeDayend> query(ChargeDayend data, PagedFliper fliper) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if (dataSource == null) {
			log.info("dsname:" + data.getDsname() + ",no this datasource.");
			return Sheet.EMPTY;
		}
		this.setDataSource(dataSource);

		String sql = "select * from chargedayend ";
		String rowsql = "select count(1) from chargedayend";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		if (isNotEmpty(data.getGameid())) {
			wheresql.append(" And gameid='").append(data.getGameid()).append(
					"'");
		}
        if (isNotEmpty(data.getGameIdLike())) {
            wheresql.append(" And gameid like '").append(data.getGameIdLike()).append(
                    "'");
        }
		if (isNotEmpty(data.getFromday())) {
			wheresql.append(" And balancedate>='").append(data.getFromday())
					.append("'");
		}
		if (isNotEmpty(data.getToday())) {
			wheresql.append(" And balancedate<='").append(data.getToday())
					.append("'");
		}

		rowsql += wheresql.toString();
		int rows = this.getSingleInt(rowsql);
		if (rows <= 0) {
			return Sheet.EMPTY;
		}

		sql += wheresql.toString();
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rows);
		}
		return new Sheet<ChargeDayend>(rows, query(ChargeDayend.class, sql));
	}

	@Override
	public ChargeDayend queryForSum(ChargeDayend data) {
		DataSource dataSource = DbConfigUtil.getPayDbSource(data.getDsname());
		if (dataSource == null) {
			log.info("dsname:" + data.getDsname() + ",no this datasource.");
		}
		this.setDataSource(dataSource);

		final ChargeDayend result = new ChargeDayend();
		String sql = "select sum(testamt) as testamt," +
				"sum(testordernums) as testordernums," +
				"sum(incomeamt) as incomeamt," +
				"sum(incomeordernums) as incomeordernums ," +
				"sum(allamt) as allamt," +
				"sum(giftamt) as giftamt,sum(vouchersMoney) as svouchersMoney from chargedayend ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		if (isNotEmpty(data.getGameid())) {
			wheresql.append(" And gameid='").append(data.getGameid()).append(
					"'");
		}
        if (isNotEmpty(data.getGameIdLike())) {
            wheresql.append(" And gameid like '").append(data.getGameIdLike()).append(
                    "'");
        }
		if (isNotEmpty(data.getFromday())) {
			wheresql.append(" And balancedate>='").append(data.getFromday())
					.append("'");
		}
		if (isNotEmpty(data.getToday())) {
			wheresql.append(" And balancedate<='").append(data.getToday())
					.append("'");
		}

		getJdbcTemplate().query(sql + wheresql.toString(),
				new RowCallbackHandler() {
					public void processRow(ResultSet resultSet)
							throws SQLException {
						result.setTestamt(resultSet.getDouble("testamt"));
						result.setTestordernums(resultSet.getInt("testordernums"));
						result.setIncomeamt(resultSet.getDouble("incomeamt"));
						result.setIncomeordernums(resultSet.getInt("incomeordernums"));
						result.setAllamt(resultSet.getDouble("allamt"));
						result.setGiftamt(resultSet.getDouble("giftamt"));
						result.setVouchersMoney(resultSet.getDouble("svouchersMoney"));
					}
				});
		return result;
	}

}
