package com.xunlei.gamepay.bo;

import java.util.List;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.dao.IDbConfigDao;
import com.xunlei.gamepay.vo.DbConfig;

public class DbConfigBoImpl extends BaseBo implements IDbConfigBo {

	private IDbConfigDao dbconfigDao;
	
	public IDbConfigDao getDbconfigDao() {
		return dbconfigDao;
	}

	public void setDbconfigDao(IDbConfigDao dbconfigDao) {
		this.dbconfigDao = dbconfigDao;
	}

	
	@Override
	public void deleteDbConfig(DbConfig data) {
		this.getDbconfigDao().delete(data);
	}

	@Override
	public void deleteDbConfigByIds(long... ids) {
		this.getDbconfigDao().deleteByIds(ids);
	}

	@Override
	public DbConfig findDbConfig(DbConfig data) {
		return this.getDbconfigDao().find(data);
	}

	@Override
	public Sheet<DbConfig> queryDbConfig(DbConfig data, PagedFliper fliper) {
		return this.getDbconfigDao().query(data, fliper);
	}

	@Override
	public void saveDbConfig(DbConfig data) {
		this.getDbconfigDao().save(data);
	}

	@Override
	public void updateDbConfig(DbConfig data) {
		this.getDbconfigDao().update(data);
	}

	public List<DbConfig> queryDbConfigForList(DbConfig data){
		return this.getDbconfigDao().queryForList(data);
	}
}
