/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.gamepay.util;

import com.xunlei.gamepay.vo.DsConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class DataSourceUtil {
    public static Map<String, String> DATASOURCENAMEMAP;
    public static Map<String, DsConfig> DATASOURCEMAP;
    public static Map<String, String> PAYDBNAMEMAP;
    public static String REPAY_KEY;
    public static String REPAY_URL;

    private static void init() {
        ResourceBundle cfg = ResourceBundle.getBundle("gamepay");
        String datasources = cfg.getString("datasources");
        String[] dsArr = datasources.split(",");
        DATASOURCENAMEMAP = new HashMap<String, String>();
        DATASOURCEMAP = new HashMap<String, DsConfig>();
        PAYDBNAMEMAP = new HashMap<String, String>();
        for (String ds : dsArr) {
            String dsname = cfg.getString("dbname_" + ds);
            DsConfig dsConfig = new DsConfig();
            dsConfig.setDburl(cfg.getString("dburl_" + ds));
            dsConfig.setDbusr(cfg.getString("dbusr_" + ds));
            dsConfig.setDbpwd(cfg.getString("dbpwd_" + ds));
            String paydbname = cfg.getString("paydbname_" + ds);
            DATASOURCENAMEMAP.put(ds, dsname);
            DATASOURCEMAP.put(ds, dsConfig);
            PAYDBNAMEMAP.put(ds, paydbname);
        }
        REPAY_KEY = cfg.getString("repay_key");
        REPAY_URL = cfg.getString("repay_url");
    }

    public static void main(String[] args) {
        for (String key : DATASOURCENAMEMAP.keySet()) {
            System.out.println(DATASOURCENAMEMAP.get(key));
        }
        for (String key : DATASOURCEMAP.keySet()) {
            DsConfig dsConfig = DATASOURCEMAP.get(key);
            System.out.println(key);
            System.out.println(dsConfig.getDbusr());
            System.out.println(dsConfig.getDburl());
            System.out.println(dsConfig.getDbpwd());
        }
    }

    static {
        DataSourceUtil.init();
    }
}

